/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.cg.entity.TableFileInfo;
import cn.eppdev.jee.cg.service.ColumnGeneratorService;
import cn.eppdev.jee.cg.service.FileGeneratorService;
import cn.eppdev.jee.cg.utils.FreeMarkerUtils;
import cn.eppdev.jee.cg.utils.GeneratorUtils;
import cn.eppdev.jee.commons.entity.BasicEntity;
import cn.eppdev.jee.conf.entity.EppdevColumn;
import cn.eppdev.jee.conf.entity.EppdevTable;
import cn.eppdev.jee.conf.service.EppdevColumnService;
import cn.eppdev.jee.conf.service.EppdevConfService;
import cn.eppdev.jee.conf.service.EppdevTableService;
import cn.eppdev.jee.share.entity.RestResult;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TableService {
    @Autowired
    EppdevTableService eppdevTableService;
    @Autowired
    ColumnGeneratorService columnGeneratorService;
    @Autowired
    EppdevColumnService eppdevColumnService;
    @Autowired
    EppdevConfService eppdevConfService;
    @Autowired
    FileGeneratorService fileGeneratorService;
    static Logger logger = LoggerFactory.getLogger(TableService.class);

    public RestResult<EppdevTable> get(String id) {
        try {
            EppdevTable table = this.eppdevTableService.get(id);
            return new RestResult(RestResult.STATUS_SUCCESS, "", (Object)table);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<Integer> update(EppdevTable eppdevTable) {
        try {
            int cnt = this.eppdevTableService.save((BasicEntity)eppdevTable);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "\u4fdd\u5b58\u6210\u529f", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "\u4fdd\u5b58\u5931\u8d25", (Object)0);
        }
        catch (Exception e) {
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }

    public RestResult<String> add(EppdevTable eppdevTable) {
        try {
            int cnt = this.eppdevTableService.insert((BasicEntity)eppdevTable);
            if (cnt == 1) {
                List columnList = this.columnGeneratorService.generateDefaultColumn();
                for (EppdevColumn column : columnList) {
                    column.setTableId(eppdevTable.getId());
                    this.eppdevColumnService.insert((BasicEntity)column);
                }
                return new RestResult(RestResult.STATUS_SUCCESS, "\u4fdd\u5b58\u6210\u529f", (Object)eppdevTable.getId());
            }
            return new RestResult(RestResult.STATUS_FAILED, "\u4fdd\u5b58\u5931\u8d25", null);
        }
        catch (Exception e) {
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<Integer> delete(String id) {
        try {
            int cnt = this.eppdevTableService.delete(id);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "Table NOT exists?", (Object)cnt);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }

    public List<TableFileInfo> getTableFileInfoList(String tableId) {
        List tableFileInfoList = GeneratorUtils.getTableFileInfoList();
        try {
            EppdevTable eppdevTable = (EppdevTable)this.get(tableId).getData();
            logger.debug("eppdevTable:{}", (Object)eppdevTable);
            ArrayList<TableFileInfo> list = new ArrayList<TableFileInfo>();
            for (TableFileInfo fileInfo : tableFileInfoList) {
                TableFileInfo tableFileInfo = new TableFileInfo(fileInfo.getType(), fileInfo.getReplace());
                tableFileInfo.setFilePath(FreeMarkerUtils.buildResult((Template)fileInfo.getFilePathTemplate(), (Object)eppdevTable));
                list.add(tableFileInfo);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return tableFileInfoList;
        }
    }

    public RestResult<String> preview(String tableId, String type) {
        try {
            String content = this.fileGeneratorService.generateContent(tableId, type);
            return new RestResult(RestResult.STATUS_SUCCESS, "\u9884\u89c8\u6210\u529f", (Object)content);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, "\u9884\u89c8\u5931\u8d25\uff1a" + e.getMessage(), null);
        }
    }
}

