/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.cg.entity.InitFileInfo;
import cn.eppdev.jee.cg.entity.InitFileType;
import cn.eppdev.jee.cg.service.FileGeneratorService;
import cn.eppdev.jee.cg.utils.FreeMarkerUtils;
import cn.eppdev.jee.cg.utils.GeneratorUtils;
import cn.eppdev.jee.conf.service.EppdevConfService;
import cn.eppdev.jee.share.entity.RestResult;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitService {
    static Logger logger = LoggerFactory.getLogger(InitService.class);
    @Autowired
    FileGeneratorService fileGeneratorService;
    @Autowired
    EppdevConfService confService;

    public RestResult<List<InitFileType>> list() {
        try {
            Map basicConf = this.confService.getAllConf();
            List initFileTypeList = GeneratorUtils.getInitFileTypeList((String)((String)basicConf.get("DB_TYPE")));
            for (InitFileType fileType : initFileTypeList) {
                for (InitFileInfo fileInfo : fileType.getFileInfoList()) {
                    if (fileInfo.getFilePath() != null && fileInfo.getFilePath().trim().length() != 0) continue;
                    fileInfo.setFilePath(FreeMarkerUtils.buildResult((Template)fileInfo.getFilePathTemplate(), (Object)basicConf));
                }
            }
            return new RestResult(RestResult.STATUS_SUCCESS, "\u83b7\u53d6\u6210\u529f", (Object)initFileTypeList);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), new ArrayList());
        }
    }

    public RestResult<String> preview(String fileName) {
        try {
            String content = this.fileGeneratorService.getInitFileContent(fileName);
            return new RestResult(RestResult.STATUS_SUCCESS, "\u83b7\u53d6\u6210\u529f", (Object)content);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }
}

