/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.cg.web;

import cn.eppdev.jee.cg.service.CgService;
import cn.eppdev.jee.share.entity.RestResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webCgController")
@RequestMapping(value={"/web/cg"})
public class CgController {
    static Logger logger = LoggerFactory.getLogger(CgController.class);
    @Autowired
    CgService cgService;

    @RequestMapping(value={"/init/file/{fileName}"})
    public String generateInitFileByFileName(@PathVariable(value="fileName") String fileName, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateInitFileByFileName(fileName);
        logger.debug("/web/cg/init/file/{}: {}", (Object)fileName, (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/init/list";
    }

    @RequestMapping(value={"/init/type/{type}"})
    public String generateInitFileByType(@PathVariable(value="type") String type, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateInitFileByType(type);
        logger.debug("/web/cg/init/type/{}: {}", (Object)type, (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/init/list";
    }

    @RequestMapping(value={"/init/all"})
    public String generateInitAllFile(RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateAllInitFile();
        logger.debug("/web/cg/init/all: {}", (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/init/list";
    }

    @RequestMapping(value={"/read/db"})
    public String readFromDb(RedirectAttributes redirectAttributes) {
        RestResult result = this.cgService.readFromDb();
        logger.debug("/web/cg/read/db -> result:{}", (Object)result);
        redirectAttributes.addFlashAttribute("message", (Object)result.getMessage());
        return "redirect:/web/conf/version/view/00000000000000000000000000000000";
    }

    @RequestMapping(value={"/version/{versionId}/type/{type}"})
    public String generateVersionFileByType(@PathVariable(value="versionId") String versionId, @PathVariable(value="type") String type, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateVerionFileByType(versionId, type);
        logger.debug("/web/cg/version/{}/type/{} -> restResult:{}", new Object[]{versionId, type, restResult});
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/version/list";
    }

    @RequestMapping(value={"/version/{versionId}/table/{tableId}/all"})
    public String generateTableCodeAll(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateAllTableFile(tableId);
        logger.debug("/web/cg/version/{}/table/{}/all", new Object[]{versionId, tableId, restResult});
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }

    @RequestMapping(value={"/version/{versionId}/table/{tableId}/type/{type}"})
    public String generateTableFileByType(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, @PathVariable(value="type") String type, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.cgService.generateTableFileByType(tableId, type);
        logger.debug("/web/cg/table/{}/type/{}: {}", new Object[]{tableId, type, restResult});
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(restResult.getMessage()) + "\n");
            for (String key : ((Map)restResult.getData()).keySet()) {
                sb.append(String.valueOf(key) + ":" + (String)((Map)restResult.getData()).get(key) + "\n");
            }
            redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }
}

