/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.entity.EppdevColumn;
import cn.eppdev.jee.conf.service.ColumnService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webColumnController")
@RequestMapping(value={"/web/conf/version/{versionId}/table/{tableId}/column"})
public class ColumnController {
    static Logger logger = LoggerFactory.getLogger(ColumnController.class);
    @Autowired
    ColumnService columnService;

    @RequestMapping(value={"/add/to"})
    public String toAdd(@PathVariable(value="tableId") String tableId, @PathVariable(value="versionId") String versionId, Model model) {
        EppdevColumn column = new EppdevColumn();
        column.setTableId(tableId);
        model.addAttribute("tableId", (Object)tableId);
        model.addAttribute("versionId", (Object)versionId);
        model.addAttribute("column", (Object)column);
        model.addAttribute("columnTypeList", (Object)this.columnService.getTypeInfoList());
        return "column/form";
    }

    @RequestMapping(value={"/add/do"})
    public String doAdd(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, EppdevColumn column, RedirectAttributes redirectAttributes) {
        try {
            this.columnService.add(column);
            redirectAttributes.addFlashAttribute("message", (Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("message", (Object)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }

    @RequestMapping(value={"/update/{id}/to"})
    public String toUpdate(@PathVariable(value="id") String columnId, @PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, Model model, RedirectAttributes redirectAttributes) {
        try {
            EppdevColumn column = (EppdevColumn)this.columnService.get(columnId).getData();
            model.addAttribute("column", (Object)column);
            model.addAttribute("columnTypeList", (Object)this.columnService.getTypeInfoList());
            return "column/form";
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            redirectAttributes.addFlashAttribute("message", (Object)("\u83b7\u53d6\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
        }
    }

    @RequestMapping(value={"/update/{id}/do"})
    public String doUpdate(@PathVariable(value="id") String id, @PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, EppdevColumn column, Model model, RedirectAttributes redirectAttributes) {
        logger.debug("/web/conf/version/{}/table/{}/column/update/do -> column:{}", new Object[]{versionId, tableId, column});
        RestResult result = this.columnService.update(column);
        logger.debug("/web/conf/version/{}/table/{}/column/update/do -> result:{}", new Object[]{versionId, tableId, result});
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            model.addAttribute("message", (Object)"\u4fee\u6539\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u4fee\u6539\u5931\u8d25\uff1a" + result.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + column.getTableId();
    }

    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable(value="id") String id, @PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, RedirectAttributes redirectAttributes) {
        RestResult result = this.columnService.delete(id);
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u5220\u9664\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u5220\u9664\u5931\u8d25: " + result.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }
}

