/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.entity.EppdevConf;
import cn.eppdev.jee.conf.service.ConfService;
import cn.eppdev.jee.share.entity.RestResult;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webBasicController")
@RequestMapping(value={"/web/conf/basic"})
public class BasicController {
    static Logger logger = LoggerFactory.getLogger(BasicController.class);
    @Autowired
    ConfService confService;

    @RequestMapping(value={"/list"})
    public String list(Model model, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.confService.listAll();
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            model.addAttribute("list", (Object)((PageInfo)restResult.getData()).getList());
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
            model.addAttribute("list", new ArrayList());
        }
        return "conf/list";
    }

    @RequestMapping(value={"/save"})
    public String doUpdate(EppdevConf conf, RedirectAttributes redirectAttributes) {
        logger.debug("/web/conf/basic/save -> conf:{}", (Object)conf);
        RestResult restResult = this.confService.update(conf);
        logger.debug("/web/conf/basic/save -> restResult:{}", (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u4fdd\u5b58\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)restResult.getMessage());
        }
        return "redirect:/web/conf/basic/list";
    }
}

