/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.conf.entity.EppdevConf;
import cn.eppdev.jee.conf.param.EppdevConfParam;
import cn.eppdev.jee.conf.service.EppdevConfService;
import cn.eppdev.jee.share.entity.RestResult;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfService {
    static Logger logger = LoggerFactory.getLogger(ConfService.class);
    @Autowired
    EppdevConfService eppdevConfService;

    public RestResult<Map<String, String>> getAllConf() {
        try {
            Map map = this.eppdevConfService.getAllConf();
            return new RestResult(RestResult.STATUS_SUCCESS, "\u83b7\u53d6\u6210\u529f", (Object)map);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<PageInfo<EppdevConf>> listAll() {
        try {
            EppdevConfParam confParam = new EppdevConfParam();
            confParam.buildOrderBy(new String[]{"id"});
            PageInfo pageInfo = this.eppdevConfService.list(confParam);
            for (EppdevConf conf : pageInfo.getList()) {
                this.eppdevConfService.getAllConf().put(conf.getConfName(), conf.getConfValue());
            }
            return new RestResult(RestResult.STATUS_SUCCESS, "\u83b7\u53d6\u6210\u529f", (Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<Integer> update(EppdevConf eppdevConf) {
        try {
            Integer cnt = this.eppdevConfService.update(eppdevConf);
            if (cnt > 0) {
                this.eppdevConfService.getAllConf().put(eppdevConf.getConfName(), eppdevConf.getConfValue());
                return new RestResult(RestResult.STATUS_SUCCESS, "\u4fdd\u5b58\u6210\u529f", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "\u4fdd\u5b58\u5931\u8d25\uff0c\u65e0\u6b64\u914d\u7f6e\uff1f", (Object)cnt);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }
}

