/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.rest;

import cn.eppdev.jee.conf.entity.EppdevTable;
import cn.eppdev.jee.conf.service.TableService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="restTableController")
@RequestMapping(value={"/rest/mapper/table"})
public class TableController {
    static Logger logger = LoggerFactory.getLogger(TableController.class);
    @Autowired
    TableService tableService;

    @RequestMapping(value={"/get/{id}"})
    public RestResult<EppdevTable> get(@PathVariable(value="id") String id) {
        logger.debug("/rest/mapper/table/get/{}", (Object)id);
        RestResult result = this.tableService.get(id);
        logger.debug("/rest/mapper/table/get/{} -> result:{}", (Object)id, (Object)result);
        return result;
    }

    @RequestMapping(value={"/update"})
    public RestResult<Integer> update(@RequestBody EppdevTable eppdevTable) {
        logger.debug("/rest/mapper/table/update -> eppdevTable:{}", (Object)eppdevTable);
        RestResult result = this.tableService.update(eppdevTable);
        logger.debug("/rest/mapper/table/update -> result:{}", (Object)result);
        return result;
    }

    @RequestMapping(value={"/add"})
    public RestResult<String> add(@RequestBody EppdevTable eppdevTable) {
        logger.debug("/rest/mapper/table/add -> eppdevTable:{}", (Object)eppdevTable);
        RestResult result = this.tableService.add(eppdevTable);
        logger.debug("/rest/mapper/table/add -> result:{}", (Object)result);
        return result;
    }

    public RestResult<Integer> delete(@PathVariable(value="id") String id) {
        logger.debug("/rest/mapper/table/delete/{}", (Object)id);
        RestResult result = this.tableService.delete(id);
        logger.debug("/rest/mapper/table/delete/{} -> result:{}", (Object)id, (Object)result);
        return result;
    }
}

