/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.service.VersionService;
import cn.eppdev.jee.share.entity.RestResult;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webVersionController")
@RequestMapping(value={"/web/conf/version"})
public class VersionController {
    static Logger logger = LoggerFactory.getLogger(VersionController.class);
    @Autowired
    VersionService versionService;

    @RequestMapping(value={"/list"})
    public String list(Model model, RedirectAttributes redirectAttributes) {
        RestResult restResult = this.versionService.listAll();
        logger.debug("/web/conf/version/list -> restResult:{}", (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            model.addAttribute("list", (Object)((PageInfo)restResult.getData()).getList());
            model.addAttribute("tableFileInfoList", (Object)this.versionService.listTableFileInfo());
        } else {
            redirectAttributes.addAttribute("message", (Object)restResult.getMessage());
            model.addAttribute("list", new ArrayList());
        }
        return "version/list";
    }

    @RequestMapping(value={"/view/{id}"})
    public String get(@PathVariable(value="id") String id, Model model, RedirectAttributes redirectAttributes) {
        logger.debug("/web/conf/view/{id} -> id:{}", (Object)id);
        RestResult restResult = this.versionService.get(id);
        logger.debug("/web/conf/view/{} -> restResult:{}", (Object)id, (Object)restResult);
        if (RestResult.STATUS_SUCCESS != restResult.getStatus()) {
            redirectAttributes.addAttribute("message", (Object)restResult.getMessage());
            return "redirect:/message";
        }
        model.addAttribute("version", restResult.getData());
        return "version/view";
    }

    @RequestMapping(value={"/add/to"})
    public String toAdd() {
        return "version/add";
    }

    @RequestMapping(value={"/add/do"})
    public String doAdd(Model model) {
        return "redirect:";
    }
}

