/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.service.ConfService;
import cn.eppdev.jee.conf.service.InitService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="webInitController")
@RequestMapping(value={"/web/conf/init"})
public class InitController {
    static Logger logger = LoggerFactory.getLogger(InitController.class);
    @Autowired
    ConfService confService;
    @Autowired
    InitService initService;

    @RequestMapping(value={"/list"})
    public String list(Model model) {
        RestResult restResult = this.initService.list();
        logger.debug("/web/conf/init/list -> restResult:{}", (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            model.addAttribute("list", restResult.getData());
            model.addAttribute("conf", (Object)this.confService.listAll());
        } else {
            model.addAttribute("message", (Object)"\u914d\u7f6e\u83b7\u53d6\u9519\u8bef");
            model.addAttribute("conf", (Object)this.confService.listAll());
        }
        return "init/list";
    }

    @RequestMapping(value={"/preview/{fileName}"})
    public String preview(@PathVariable(value="fileName") String fileName, Model model) {
        RestResult restResult = this.initService.preview(fileName);
        model.addAttribute("fileName", (Object)fileName);
        logger.debug("/web/conf/init/preview/{} -> restResult:{}", (Object)fileName, (Object)restResult);
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            model.addAttribute("content", restResult.getData());
        } else {
            model.addAttribute("message", (Object)restResult.getMessage());
        }
        return "init/preview";
    }
}

