/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.cg.entity.TableFileInfo;
import cn.eppdev.jee.cg.utils.GeneratorUtils;
import cn.eppdev.jee.commons.entity.BasicEntity;
import cn.eppdev.jee.commons.param.BasicParam;
import cn.eppdev.jee.conf.entity.EppdevColumn;
import cn.eppdev.jee.conf.entity.EppdevIndex;
import cn.eppdev.jee.conf.entity.EppdevTable;
import cn.eppdev.jee.conf.entity.EppdevVersion;
import cn.eppdev.jee.conf.param.EppdevVersionParam;
import cn.eppdev.jee.conf.service.EppdevColumnService;
import cn.eppdev.jee.conf.service.EppdevIndexService;
import cn.eppdev.jee.conf.service.EppdevTableService;
import cn.eppdev.jee.conf.service.EppdevVersionService;
import cn.eppdev.jee.share.entity.RestResult;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VersionService {
    static Logger logger = LoggerFactory.getLogger(VersionService.class);
    @Autowired
    EppdevVersionService eppdevVersionService;
    @Autowired
    EppdevTableService eppdevTableService;
    @Autowired
    EppdevColumnService eppdevColumnService;
    @Autowired
    EppdevIndexService eppdevIndexService;

    public RestResult<EppdevVersion> get(String id) {
        try {
            EppdevVersion version = this.eppdevVersionService.get(id);
            if (version != null) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success!", (Object)version);
            }
            return new RestResult(RestResult.STATUS_FAILED, "this version does not exists\uff1f", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    @Transactional(readOnly=false)
    public RestResult<String> add(String versionName, String fromVersionId) {
        try {
            EppdevVersion oldVersion = this.eppdevVersionService.get(fromVersionId);
            if (oldVersion == null) {
                return new RestResult(RestResult.STATUS_FAILED, "Source Version does NOT exists?", null);
            }
            EppdevVersionParam param = new EppdevVersionParam();
            param.setVersionName(versionName);
            PageInfo pageInfo = this.eppdevVersionService.list((BasicParam)param);
            if (pageInfo.getTotal() > 0L) {
                return new RestResult(RestResult.STATUS_FAILED, "Version name exists?", null);
            }
            EppdevVersion newVersion = new EppdevVersion();
            newVersion.setVersionName(versionName);
            this.eppdevVersionService.save((BasicEntity)newVersion);
            String newVersionId = newVersion.getId();
            for (EppdevTable table : oldVersion.getTableList()) {
                List columnList = this.eppdevColumnService.listByTableId(table.getId());
                List indexList = this.eppdevIndexService.listByTableId(table.getId());
                table.setId(null);
                table.setVersionId(newVersionId);
                this.eppdevTableService.save((BasicEntity)table);
                String newTableId = table.getId();
                for (EppdevColumn column : columnList) {
                    column.setTableId(newTableId);
                    column.setId(null);
                    this.eppdevColumnService.save((BasicEntity)column);
                }
                for (EppdevIndex index : indexList) {
                    index.setTableId(newTableId);
                    index.setId(null);
                    this.eppdevIndexService.save((BasicEntity)index);
                }
            }
            return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)newVersionId);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<Integer> delete(String id) {
        try {
            int cnt = this.eppdevVersionService.delete(id);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "Failed. Version NOT exist?", (Object)0);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }

    public RestResult<PageInfo<EppdevVersion>> listAll() {
        try {
            PageInfo pageInfo = this.eppdevVersionService.listAll();
            return new RestResult(RestResult.STATUS_SUCCESS, "\u83b7\u53d6\u6210\u529f", (Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public List<TableFileInfo> listTableFileInfo() {
        return GeneratorUtils.getTableFileInfoList();
    }
}

