/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.cg.entity.ColumnTypeInfo;
import cn.eppdev.jee.cg.service.ColumnGeneratorService;
import cn.eppdev.jee.commons.entity.BasicEntity;
import cn.eppdev.jee.conf.entity.EppdevColumn;
import cn.eppdev.jee.conf.service.EppdevColumnService;
import cn.eppdev.jee.conf.service.EppdevConfService;
import cn.eppdev.jee.share.entity.RestResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ColumnService {
    static Logger logger = LoggerFactory.getLogger(ColumnService.class);
    @Autowired
    EppdevColumnService eppdevColumnService;
    @Autowired
    EppdevConfService eppdevConfService;
    @Autowired
    ColumnGeneratorService generatorService;

    public RestResult<EppdevColumn> get(String id) {
        try {
            EppdevColumn eppdevColumn = (EppdevColumn)this.eppdevColumnService.get(id);
            if (eppdevColumn != null) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)eppdevColumn);
            }
            return new RestResult(RestResult.STATUS_FAILED, "Column NOT exists?", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    @Transactional(readOnly=false)
    public RestResult<String> add(EppdevColumn eppdevColumn) {
        try {
            List list = this.eppdevColumnService.listByTableId(eppdevColumn.getTableId());
            int maxSortIndex = 1;
            for (EppdevColumn column : list) {
                if (column.getSortIndex() >= 10000 || column.getSortIndex() <= 1) continue;
                maxSortIndex = column.getSortIndex();
            }
            eppdevColumn.setSortIndex(Integer.valueOf(maxSortIndex + 1));
            int cnt = this.eppdevColumnService.save((BasicEntity)eppdevColumn);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)eppdevColumn.getId());
            }
            return new RestResult(RestResult.STATUS_FAILED, "Failed. Column name exists?", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    @Transactional(readOnly=false)
    public RestResult<Integer> update(EppdevColumn eppdevColumn) {
        try {
            int cnt = this.eppdevColumnService.save((BasicEntity)eppdevColumn);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "Failed. Column NOT exists?", (Object)0);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }

    @Transactional(readOnly=false)
    public RestResult<Integer> delete(String id) {
        try {
            int cnt = this.eppdevColumnService.delete(id);
            if (cnt == 1) {
                return new RestResult(RestResult.STATUS_SUCCESS, "Success", (Object)cnt);
            }
            return new RestResult(RestResult.STATUS_FAILED, "Failed. Column NOT exists?", (Object)0);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), (Object)0);
        }
    }

    public List<ColumnTypeInfo> getTypeInfoList() {
        return this.generatorService.listAllColumnType(this.eppdevConfService.getDbType());
    }
}

