/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.rest;

import cn.eppdev.jee.conf.entity.EppdevVersion;
import cn.eppdev.jee.conf.service.EppdevVersionService;
import cn.eppdev.jee.conf.service.VersionService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="restVersionController")
@RequestMapping(value={"/rest/mapper/version"})
public class VersionController {
    static Logger logger = LoggerFactory.getLogger(VersionController.class);
    @Autowired
    EppdevVersionService eppdevVersionService;
    @Autowired
    VersionService versionService;

    @RequestMapping(value={"/get/{id}"})
    public RestResult<EppdevVersion> get(@PathVariable(value="id") String id) {
        logger.debug("/rest/mapper/version/get/{}", (Object)id);
        RestResult result = this.versionService.get(id);
        logger.debug("/rest/mapper/version/get/{} ->result:{}", (Object)id, (Object)result);
        return result;
    }

    @RequestMapping(value={"/add"})
    public RestResult<String> add(@RequestBody EppdevVersion version) {
        logger.debug("/rest/mapper/version/add -> version:{}", (Object)version);
        RestResult result = this.versionService.add(version.getVersionName(), version.getFromVersionId());
        logger.debug("/rest/mapper/version/add -> result:{}", (Object)result);
        return result;
    }

    @RequestMapping(value={"/delete/{id}"})
    public RestResult<Integer> delete(@PathVariable(value="id") String id) {
        logger.debug("/rest/mapper/version/delete/{}", (Object)id);
        RestResult result = this.versionService.delete(id);
        logger.debug("/rest/mapper/version/delete/{} -> result:{}", (Object)id, (Object)result);
        return result;
    }
}

