/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.rest;

import cn.eppdev.jee.conf.entity.EppdevColumn;
import cn.eppdev.jee.conf.service.ColumnService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="restColumnController")
@RequestMapping(value={"/rest/mapper/column"})
public class ColumnController {
    static Logger logger = LoggerFactory.getLogger(ColumnController.class);
    @Autowired
    ColumnService columnService;

    @RequestMapping(value={"/add"})
    public RestResult<String> add(@RequestBody EppdevColumn eppdevColumn) {
        logger.debug("/rest/mapper/column/add -> eppdevColumn:{}", (Object)eppdevColumn);
        RestResult result = this.columnService.add(eppdevColumn);
        logger.debug("/rest/mapper/column/add -> result:{}", (Object)result);
        return result;
    }

    @RequestMapping(value={"/get/{id}"})
    public RestResult<EppdevColumn> get(@PathVariable(value="Id") String id) {
        logger.debug("/rest/mapper/column/get/{}", (Object)id);
        RestResult result = this.columnService.get(id);
        logger.debug("/rest/mapper/column/get/{} -> result:{}", (Object)id, (Object)result);
        return result;
    }

    @RequestMapping(value={"/update"})
    public RestResult<Integer> update(@RequestBody EppdevColumn eppdevColumn) {
        logger.debug("/rest/mapper/column/update -> eppdevColumn:{}", (Object)eppdevColumn);
        RestResult result = this.columnService.update(eppdevColumn);
        logger.debug("/rest/mapper/column/update -> result:{}", (Object)result);
        return result;
    }

    @RequestMapping(value={"/delete/{id}"})
    public RestResult<Integer> delete(@PathVariable(value="id") String id) {
        logger.debug("/rest/mapper/column/delete/{}", (Object)id);
        RestResult result = this.columnService.delete(id);
        logger.debug("/rest/mapper/column/delete/{} -> result:{}", (Object)id, (Object)result);
        return result;
    }
}

