/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.web.common;

import cn.eova.tools.x;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    static String phoneReg = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    static String tableReg = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    static Pattern phonePat = Pattern.compile(phoneReg, 2);
    static Pattern tablePat = Pattern.compile(tableReg, 2);

    public static Boolean isMobile(HttpServletRequest request) {
        String ua = WebUtil.getUserAgent(request);
        if (null == ua) {
            return false;
        }
        Matcher matcherPhone = phonePat.matcher(ua);
        Matcher matcherTable = tablePat.matcher(ua);
        if (matcherPhone.find() || matcherTable.find()) {
            return true;
        }
        return false;
    }

    public static String getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (x.isEmpty((Object)userAgent)) {
            userAgent = request.getHeader("http_user_agent");
        }
        return userAgent;
    }

    public static String getRealIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.indexOf(",") > -1) {
            ip = ip.split(",")[0];
        }
        return ip;
    }
}

