/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.web.base;

import cn.eova.tools.x;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import com.jfinal.kit.Ret;
import com.jfinal.render.TemplateRender;

/**
 * 底层基础Web控制器
 * 脱离业务的控制器的底层实现
 */
public class BaseWebController extends Controller {

    protected String http(String domain) {
        return "http://" + x.conf.get(domain);
    }

    @NotAction
    public void OK() {
        renderJson(Ret.ok());
    }

    @NotAction
    public void NO(String msg) {
        renderJson(Ret.fail("msg", msg));
    }

    @NotAction
    public void renderMsg(String msg) {
        String style = "<link rel=\"stylesheet\" href=\"/eova/plugins/eova/css/eova.render.css\">";
        renderHtml(style + "<div class='eova-msg-error'>" + msg + "</div>");
    }

    @NotAction
    public void renderEnjoy(String view) {
        render(new TemplateRender(view));
    }

}