/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.web.base;

import cn.eova.tools.x;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import com.jfinal.kit.Ret;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.render.TemplateRender;

public class BaseController extends Controller {

    /**SID Cookie Key**/
    public static final String CKSID = "eovasid";
    /**SID Field Key**/
    public static final String SID = "sid";// 可以统一成eovasid

    protected String http(String domain) {
        return "http://" + x.conf.get(domain);
    }

    @NotAction
    public String SID() {
        // Request域优先于 Cookie域
        String sid = getAttr(CKSID);
        if (sid == null) {
            sid = getCookie(CKSID);
        }
        return sid;
    }

    /**
     * 获取按钮输入框的值
     * <pre>
     * Integer id = getSelectValue("id");
     *
     * if (x.isEmpty(val)) {
     *     renderJson(new Easy("参数不能为空！"));
     *     return;
     * }
     *
     * Db.update("update xxx set xx = ? where id = ?", val, id);
     * renderJson(Easy.sucess());
     *</pre>
     */
    protected String getInputValue() {
        return getPara("input");
    }

    /**
     * 快速GET Request请求参数
     * @param modelClass
     * @param fields
     * @return
     */
    protected <T extends Model> T getModel(Class<? extends Model> modelClass, String... fields) {
        Model<?> m = null;
        try {
            m = modelClass.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }

        for (String field : fields) {
            if (!field.contains(" ")) {
                m.set(field, getPara(field));
                continue;
            }
            String[] ss = field.split("\\s+");
            String type = ss[0];
            String col = ss[1];
            Object val = "";
            if (type.equals("int")) {
                val = getParaToInt(col);
            } else if (type.equals("long")) {
                val = getParaToLong(col);
            } else if (type.equals("double")) {
                val = x.toDouble(getPara());
            } else if (type.equals("boolean")) {
                val = getParaToBoolean(col);
            } else if (type.equals("date")) {
                val = getParaToDate(col);
            } else {
                val = getPara(col);
            }
            m.set(col, val);
        }

        return (T) m;
    }


    @NotAction
    public void OK() {
        renderJson(Ret.ok());
    }

    @NotAction
    public void NO(String msg) {
        renderJson(Ret.fail("msg", msg));
    }

    @NotAction
    public void renderMsg(String msg) {
        String style = "<link rel=\"stylesheet\" href=\"/eova/plugins/eova/css/eova.render.css\">";
        renderHtml(style + "<div class='eova-msg-error'>" + msg + "</div>");
    }

    @NotAction
    public void renderEnjoy(String view) {
        render(new TemplateRender(view));
    }

}