/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.web.base;

import java.util.Map;

import cn.eova.tools.kit.HtmlKit;

/**
 * 基础模版共享方法
 * #ws()
 *
 * @author Jieven
 */
public class BaseSharedMethod {

	private Map<String, String> conf;

	public BaseSharedMethod(Map<String, String> conf) {
		this.conf = conf;
	}

	public String conf(String key){
		return conf.get(key);
	}

	public String ws(String domain) {
		return "ws://" + conf.get(domain);
	}

	public String wss(String domain) {
		return "wss://" + conf.get(domain);
	}

	public String htt(String domain) {
		return "//" + conf.get(domain);
	}

	public String http(String domain) {
		return "http://" + conf.get(domain);
	}

	public String https(String domain) {
		return "https://" + conf.get(domain);
	}

	public String dir(String dirName) {
		return conf.get("dir.static") + conf.get("dir." + dirName);
	}

	//	 非法内容过滤,适用于纯文本输出
	public String xss(String s) {
		return HtmlKit.XSSEncode(s);
	}

	// html内容转码
	public String html(String s) {
		return HtmlKit.HTMLEncode(s);
	}
}