/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.tools;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.eova.tools.kit.TypeKit;
import cn.eova.tools.tool.ConfigTool;
import cn.eova.tools.tool.EncryptTool;
import cn.eova.tools.tool.FileTool;
import cn.eova.tools.tool.HttpTool;
import cn.eova.tools.tool.LogTool;
import cn.eova.tools.tool.MathTool;
import cn.eova.tools.tool.NetTool;
import cn.eova.tools.tool.ResourceTool;
import cn.eova.tools.tool.StringTool;
import cn.eova.tools.tool.TimeTool;

/**
 * 神器 · 疾风之刃<br>
 * <br>
 * 开发者有三件必经之事：简单、复杂、然后简单<br>
 * KISS原则:用户体验的高层境界，就是要把一个东西做得连小白都会用，因而也被称为<<懒人原则>>。<br>
 * <br>
 * What：模块化的工具箱,物以类聚,依赖集中<br>
 * Where：x.xxx.xxx简短快捷的输入操作,让你众享丝滑欲罢不能<br>
 * Why：整合常用高频工具类,编码速度+50%,代码量-30%<br>
 * <br>
 *
 * 为天地立心，为生民立命，<br>
 * 为往圣继绝学，为万世开太平。<br>
 *
 * @author Jieven
 * 
 */
public class x {

	public static StringTool str = new StringTool();
	public static MathTool math = new MathTool();
	public static ConfigTool conf = new ConfigTool();
	public static TimeTool time = new TimeTool();
	public static LogTool log = new LogTool();
	public static HttpTool http = new HttpTool();
	public static NetTool net = new NetTool();
	public static FileTool file = new FileTool();
	public static ResourceTool resource = new ResourceTool();
	public static EncryptTool encrypt = new EncryptTool();

	/**默认数据源名称**/
	public static final String DS_MAIN = "main";
	/**EOVA数据源名称**/
	public static final String DS_EOVA = "eova";

	/**
	 * 判空 Collection、Map、数组、Iterator、Iterable 类型对象中的元素个数是否为 0
	 * 规则：
	 * 1：null 返回 true
	 * 2：List、Set 等一切继承自 Collection 的，返回 isEmpty()
	 * 3：Map 返回 isEmpty()
	 * 4：数组返回 length == 0
	 * 5：Iterator 返回  ! hasNext()
	 * 6：Iterable 返回  ! iterator().hasNext()
	 */
	public static boolean isEmpty(Object o) {
		if (o == null) {
			return true;
		}
		if (o instanceof Collection) {
			return ((Collection<?>) o).isEmpty();
		}
		if (o instanceof Map) {
			return ((Map<?, ?>) o).isEmpty();
		}
		if (o.getClass().isArray()) {
			return Array.getLength(o) == 0;
		}
		if (o instanceof Iterator) {
			return !((Iterator<?>) o).hasNext();
		}
		if (o instanceof Iterable) {
			return !((Iterable<?>) o).iterator().hasNext();
		}
		if (o instanceof String) {
			// Mysql 5.7 迁移到 8.0 时, 可能会出现 NULL => 'null', 所以特此兼容.
			if (o.toString().equals("") || o.toString().equals("null")) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 对象组中是否存在 Empty Object
	 * @param os 对象组
	 * @return
	 */
	public static boolean isOneEmpty(Object... os) {
		for (Object o : os) {
			if(isEmpty(o)){
				return true;
			}
		}
		return false;
	}

	/**
	 * 对象组中是否全是 Empty Object
	 * @param os
	 * @return
	 */
	public static boolean isAllEmpty(Object... os) {
		for (Object o : os) {
			if (!isEmpty(o)) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 是否为数字
	 * @param obj
	 * @return
	 */
	public static boolean isNum(Object obj) {
		try {
			Integer.parseInt(obj.toString());
		} catch (Exception e) {
			return false;
		}
		return true;
	}
	
	/**
	 * 字符串是否为 true
	 * @param str
	 * @return
	 */
	public static boolean isTrue(Object str) {
		if (isEmpty(str)) {
			return false;
		}
		str = str.toString().trim().toLowerCase();
		if (str.equals("true") || str.equals("on")) {
			return true;
		}
		return false;
	}

	/**
	 * 强转->Integer
	 * @param obj
	 * @return
	 */
	public static Integer toInt(Object obj) {
		return Integer.parseInt(obj.toString());
	}

	/**
	 * 强转->Integer
	 * @param obj
	 * @param defaultValue
	 * @return
	 */
	public static Integer toInt(Object obj, int defaultValue) {
		if (isEmpty(obj)) {
			return defaultValue;
		}
		return toInt(obj);
	}

	/**
	 * 强转->Long
	 * @param obj
	 * @return
	 */
	public static long toLong(Object obj) {
		return Long.parseLong(obj.toString());
	}

	/**
	 * 强转->Long
	 * @param obj
	 * @param defaultValue
	 * @return
	 */
	public static long toLong(Object obj, long defaultValue) {
		if (isEmpty(obj)) {
			return defaultValue;
		}
		return toLong(obj);
	}

	/**
	 * 强转->Double
	 * @param obj
	 * @return
	 */
	public static double toDouble(Object obj) {
		return Double.parseDouble(obj.toString());
	}
	
	/**
	 * 强转->Boolean
	 * @param obj
	 * @return
	 */
	public static Boolean toBoolean(Object obj) {
		return Boolean.parseBoolean(obj.toString());
	}
	
	/**
	 * 强转->Boolean
	 * @param obj
	 * @param defaultValue
	 * @return
	 */
	public static Boolean toBoolean(Object obj, Boolean defaultValue) {
		if (isEmpty(obj)) {
			return defaultValue;
		}
		return toBoolean(obj);
	}
	
	/**
	 * 强转->java.util.Date
	 * @param obj 时间(支持 字符串, Date, Temporal)
	 * @return
	 */
	public static Date toDate(Object obj) {
		return TypeKit.toDate(obj);
	}

	/**
	 * 集合转数组
	 * @param list
	 * @return
	 */
	public static Object[] toArray(List<Object> list) {
		Object[] os = new Object[list.size()];
		list.toArray(os);
		return os;
	}

	/**
	 * 一夜无梦
	 * @param ms
	 */
	public static void sleep(long ms){
		try {
			Thread.sleep(ms);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 目标集合中是否包含指定对象(按对象字符串值判定)
	 * @param arrs 目标集合
	 * @param s 指定对象
	 * @return
	 */
	public static boolean isContains(Collection<?> arrs, Object s) {
		for (Object o : arrs) {
			if (o.toString().equals(s.toString())) {
				return true;
			}
		}
		return false;
	}
}