/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools.tool;

import java.text.DecimalFormat;

import cn.eova.tools.x;

/**
 * 数学运算
 *
 * @author Jieven
 */
public class MathTool {

    /**
     * 金额元转分
     * double 进行乘除运算极易丢失精度, 导致总额不准]
     * 强烈推荐, 金额使用int保存, 便于计算, 精度准确.
     *
     * @param rmb #.00 元 (默认只保留2位小数, 忽略毫厘)
     * @return RMB 分
     */
    public int toCent(Double rmb) {
        return x.toInt(new DecimalFormat("#.00").format(rmb).replace(".", ""));
    }

}
