/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools.tool;

import cn.hutool.log.StaticLog;

/**
 * 日志
 * 使用方法: x.log.info("文案文案文案文案:{}, {}", 参数1, 参数2);
 * @author Jieven
 */
public class LogTool {


    public void info(String s, Object... args) {
        StaticLog.info(s, args);
    }

    public void debug(String s, Object... args) {
        StaticLog.debug(s, args);
    }

    public void error(String s, Object... args) {
        StaticLog.error(s, args);
    }

    /**
     *
     * @param s 不支持动态参数 需手工format
     * @param e 参数调整到最后 与 Logger 规范一致
     */
    public void error(String s, Throwable e) {
        StaticLog.error(e, s);
    }

    public void error(Throwable e, String s, Object... args) {
        StaticLog.error(e, s, args);
    }

    public void warn(String s, Object... args) {
        StaticLog.warn(s, args);
    }
}
