/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools.tool;

import java.security.MessageDigest;

/**
 * 加密解密
 *
 * @author Jieven
 */
public class EncryptTool {

    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";


    /**
     * MD5加密
     * @param str 待加密字符串
     * @return
     */
    public String md5(String str) {
        return encrypt(MD5, str);
    }

    /**
     * SHA1加密
     * @param str 待加密字符串
     * @return
     */
    public String sha1(String str) {
        return encrypt(SHA1, str);
    }

    /**
     * 字符单向加密算法
     * @param str
     * @return
     */
    private String encrypt(String type, String str) {
        try {
            String result = "";
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] bytes = md.digest(str.getBytes("UTF-8"));
            for (byte b : bytes) {
                String hex = Integer.toHexString(b & 0xFF).toUpperCase();
                result += ((hex.length() == 1) ? "0" : "") + hex;
            }
            return result;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取双重伪装加密
     * @return
     */
    public String sm32(String str) {
        return sha1(md5(str)).substring(0, 32);
    }

}
