/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools.tool;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import cn.eova.tools.x;

/**
 * @author Jieven
 */
public class ConfigTool {

    /**
     * 配置属性
     **/
    private static final Map<String, String> props = new HashMap<String, String>();

    public Map<String, String> getProps() {
        // 尝试自动加载配置
        return ConfigTool.props;
    }

    public void addConfig(String key, String val) {
        props.put(key, val);
    }

    public void addProp(Properties properties) {
        properties.forEach((k, v) -> {
            props.put(k.toString(), v.toString());
        });
    }

    public String get(String key) {
        String value = getProps().get(key);
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public String get(String key, String defaultValue) {
        String value = getProps().get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getBool(String key, boolean defaultValue) {
        String val = get(key);
        if (x.isEmpty(val))
            return defaultValue;
        if (val.equals("1") || val.equals("true")) {
            return true;
        }
        return false;
    }

    public int getInt(String key, int defaultValue) {
        return x.toInt(get(key), defaultValue);
    }

}
