/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.tools.string;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;

import cn.eova.tools.EovaTools;

/**
 * 字符串加密与解密
 * @see EovaTools.EncryptTool
 *
 * @author Jieven
 * @date 2014-5-12
 */
@Deprecated
public class EncryptUtil {

    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";

    /**
     * 字符单向加密算法
     * @param str 加密
     * @return
     */
    private static String encrypt(String type, String str) {
        try {
            String result = "";
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] bytes = md.digest(str.getBytes("UTF-8"));
            for (byte b : bytes) {
                String hex = Integer.toHexString(b & 0xFF).toUpperCase();
                result += ((hex.length() == 1) ? "0" : "") + hex;
            }
            return result;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * MD5加密
     * @param str
     * @return
     */
    public static String getMd5(String str) {
        return encrypt(MD5, str);
    }

    /**
     * SHA1加密
     * @param str
     * @return
     */
    public static String getSha1(String str) {
        return encrypt(SHA1, str);
    }

    /**
     * 获取双重伪装加密
     * @return
     */
    public static String getSM32(String str) {
        return getSha1(getMd5(str)).substring(0, 32);
    }

    private static final String MK = "11111111111111111111111111111111111111111111111111111111";
    // 指定DES加密解密所用的密钥
    private static Key key;

    /**
     * 设置加密的校验码
     * @Date:2012-10-16 下午04:25:13
     * @ClassDescription:
     */
    private static void setkey(String keyStr) {
        try {
            DESKeySpec objDesKeySpec = new DESKeySpec(keyStr.getBytes("UTF-8"));
            SecretKeyFactory objKeyFactory = SecretKeyFactory.getInstance("DES");
            key = objKeyFactory.generateSecret(objDesKeySpec);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 对字符串进行DES加密，返回BASE64编码的加密字符串
    public static String encryptString(String str) {
        setkey(MK);
        byte[] bytes = str.getBytes();
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] encryptStrBytes = cipher.doFinal(bytes);
            return Base64.getEncoder().encodeToString(encryptStrBytes);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 对BASE64编码的加密字符串进行解密，返回解密后的字符串
    public static String decryptString(String str) {
        setkey(MK);
        try {
            byte[] bytes = Base64.getDecoder().decode(str);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(Cipher.DECRYPT_MODE, key);
            bytes = cipher.doFinal(bytes);
            return new String(bytes);
        } catch (Exception e) {
            throw new RuntimeException();
        }
    }

}