/**
 * Copyright (c) 2011-2023, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools.serializer;

import org.apache.fury.Fury;
import org.apache.fury.ThreadLocalFury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.Language;

/**
 * Fury 高性能序列化方案 性能比JDK快百倍
 * 优点: 多线程安全 高性能 多语言
 * 缺点: 单独依赖Fury
 *
 * @author Jieven
 */
public class FurySerializer implements ISerializer {

    public static final ISerializer me = new FurySerializer();

    /**
     * 多线程支持
     */
    private static final ThreadSafeFury fury = new ThreadLocalFury(classLoader -> {
        return Fury.builder().withLanguage(Language.JAVA)
                .withClassLoader(classLoader)
                .withRefTracking(false)
                .requireClassRegistration(false)
                .build();
    });

    @Override
    public byte[] serialize(Object obj) {
        return fury.serialize(obj);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0)
            return null;

        return fury.deserialize(bytes);
    }
}



