/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.tools.kit;

public class SysKit {

	public static boolean isWindows() {
		return getSystemType().equalsIgnoreCase("windows");
	}

	public static boolean isLinux() {
		return getSystemType().equals("linux");
	}

	public static boolean isMac() {
		return getSystemType().equals("mac");
	}


	public static String getSystemType() {
		String osName = System.getProperty("os.name");
		if (osName.contains("Mac")) {
			return "mac";
		} else if (osName.contains("Windows")) {
			return "windows";
		} else if (osName.contains("Linux")) {
			return "linux";
		} else {
			return "other";
		}

	}

}