/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.tools;

import java.security.Security;
import java.util.Properties;

import cn.eova.tools.kit.Prop;
import cn.eova.tools.kit.PropKit;
import cn.eova.tools.string.StringPool;

public class EovaTools {

    static {
        // Starting from Java8 u151, the `Unlimited Strength Jurisdiction Policy Files`
        // are included with Java, but has to be enabled.
        // They are enabled on Java9 by default.
        Security.setProperty("crypto.policy", "unlimited");
    }

    /**
     * 临时文件默认前缀
     */
    public static String tempFilePrefix = "eova-";

    /**
     * 默认字符集
     */
    public static String encoding = StringPool.UTF_8;

    /**
     * I/O操作的缓冲区大小
     */
    public static int ioBufferSize = 16384;

    /**
     * 控制{@code Unsafe}使用的标志(如果系统检测到)。默认启用。
     */
    public static boolean unsafeUsageEnabled = true;

    /**
     * 初始化 eova-tools
     */
    public static void init(Properties properties) {
        Prop prop = PropKit.useFirstFound("dev.config", "test.config", "pre.config", "pro.config", "prd.config");
        // 配置
        x.conf.addProp(properties);
    }

}
