/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.tool;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimeTool {
    private static final String TIMES = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIME = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE = "yyyy-MM-dd";

    public long now() {
        return System.currentTimeMillis();
    }

    @Deprecated
    public String formatMS(long ms, String pattern) {
        return this.format(ms, pattern);
    }

    public String format(long ms, String pattern) {
        return this.format(new Date(ms), pattern);
    }

    public String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public String formatDate(long ms) {
        return this.format(ms, DATE);
    }

    public String formatDate(Date date) {
        return this.format(date, DATE);
    }

    public String formatTime(long ms) {
        return this.format(ms, TIME);
    }

    public String formatTime(Date date) {
        return this.format(date, TIME);
    }

    public String formatNow(String pattern) {
        return this.formatMS(this.now(), pattern);
    }

    public String formatNowTime() {
        return this.format(this.now(), TIME);
    }

    public String formatNowTimes() {
        return this.format(this.now(), TIMES);
    }

    public String formatNowDate() {
        return this.format(this.now(), DATE);
    }

    public long parse(String time) {
        LocalDateTime time1 = LocalDateTime.parse(time, DateTimeFormatter.ofPattern(TIME));
        return LocalDateTime.from(time1).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public void costTime(long time) {
        System.err.println("Load Cost Time:" + (System.currentTimeMillis() - time) + "ms\n");
    }

    public boolean isTimeout(Long oldTime, int timeoutSec) {
        if (oldTime == null) {
            return true;
        }
        return (System.currentTimeMillis() - oldTime) / 1000L > (long)timeoutSec;
    }

    public Timestamp calcDay(long n) {
        return new Timestamp(this.now() + 86400000L * n);
    }

    public Timestamp calcHour(long n) {
        return new Timestamp(this.now() + 3600000L * n);
    }

    public Timestamp calcMin(long n) {
        return new Timestamp(this.now() + 60000L * n);
    }

    public Timestamp calcSec(long n) {
        return new Timestamp(this.now() + 1000L * n);
    }

    public List<String> parseDates(String start, String end) {
        return Stream.iterate(LocalDate.parse(start), localDate -> localDate.plusDays(1L)).limit(ChronoUnit.DAYS.between(LocalDate.parse(start), LocalDate.parse(end)) + 1L).map(LocalDate::toString).collect(Collectors.toList());
    }
}

