/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.tool;

import cn.eova.tools.x;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTool {
    public String format(Object str) {
        return "'" + str.toString() + "'";
    }

    public String formatPath(String path, Object ... args) {
        return String.format(path.replace("/", File.separator), args);
    }

    public String join(Collection<?> s, String parcel, String sign) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<?> iter = s.iterator();
        StringBuilder sb = new StringBuilder(parcel + iter.next().toString() + parcel);
        while (iter.hasNext()) {
            sb.append(sign).append(parcel + iter.next() + parcel);
        }
        return sb.toString();
    }

    public String join(Collection<?> s) {
        return this.join(s, "", ",");
    }

    public String delStart(String s, String sign) {
        if (s.startsWith(sign)) {
            return s.substring(s.lastIndexOf(sign) + sign.length(), s.length());
        }
        return s;
    }

    public String delEnd(String s, String sign) {
        if (x.isEmpty(s)) {
            return s;
        }
        if (s.endsWith(sign)) {
            return s.substring(0, s.lastIndexOf(sign));
        }
        return s;
    }

    public String replaceBlank(String s) {
        if (x.isEmpty(s)) {
            return s;
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(s);
        return m.replaceAll("");
    }

    public String formatJson(String json) {
        int level = 0;
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (level > 0 && '\n' == sb.charAt(sb.length() - 1)) {
                sb.append(this.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    sb.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    sb.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append("\n");
                    sb.append(this.getLevelStr(--level));
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String getLevelStr(int level) {
        StringBuffer levelStr = new StringBuffer();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("  ");
        }
        return levelStr.toString();
    }
}

