/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.tool;

import cn.eova.tools.x;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignTool {
    public static String SIGN_MD5 = "md5";
    public static String SIGN_HMAC = "hmac";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    public String appKey;
    public String appSecret;
    public String getway;
    public String signMethod;

    public SignTool(String signMethod, String appKey, String appSecret, String getway) {
        this(signMethod, appKey, appSecret);
        this.getway = getway;
    }

    public SignTool(String signMethod, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.signMethod = signMethod;
    }

    public SignUrl generate(String method, String body) {
        return this.generate(method, body, x.time.now());
    }

    public SignUrl generate(String method, String body, long timestamp) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", this.appKey);
        params.put("method", method);
        params.put("timestamp", timestamp + "");
        String sign = SignTool.sign(params, body, this.appSecret, this.signMethod);
        String link = SignTool.toGetQuery(params);
        String url = String.format("%s?" + link + "&sign=%s", this.getway, sign);
        return new SignUrl(sign, url);
    }

    public static String sign(Map<String, String> params, String body, String secret, String signMethod) {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if (SIGN_MD5.equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (x.isOneEmpty(key, value)) continue;
            query.append((String)key).append(value);
        }
        if (body != null) {
            query.append(body);
        }
        if (SIGN_HMAC.equals(signMethod)) {
            byte[] bytes = SignTool.encryptHMAC(query.toString(), secret);
            return SignTool.byte2hex(bytes);
        }
        query.append(secret);
        return x.encrypt.md5(query.toString());
    }

    private static String toGetQuery(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    private static byte[] encryptHMAC(String data, String secret) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(UTF8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(UTF8));
        }
        catch (GeneralSecurityException gse) {
            x.log.error("HMAC\u7b7e\u540d\u7b97\u6cd5\u5f02\u5e38:" + gse.getMessage(), new Object[0]);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static class SignUrl {
        private String sign;
        private String url;

        public SignUrl(String sign, String url) {
            this.sign = sign;
            this.url = url;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

