/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.string;

import java.io.UnsupportedEncodingException;

public class EncodeUtil {
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";

    public static String toASCII(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, US_ASCII);
    }

    public static String toISO_8859_1(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, ISO_8859_1);
    }

    public static String toUTF_8(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, UTF_8);
    }

    public static String toUTF_16BE(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, UTF_16BE);
    }

    public static String toUTF_16LE(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, UTF_16LE);
    }

    public static String toUTF_16(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, UTF_16);
    }

    public static String toGBK(String str) throws UnsupportedEncodingException {
        return EncodeUtil.changeCharset(str, GBK);
    }

    public static String changeCharset(String str, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes();
            return new String(bs, newCharset);
        }
        return null;
    }

    public static String changeCharset(String str, String oldCharset, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes(oldCharset);
            return new String(bs, newCharset);
        }
        return null;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String str = "\u9519\u8bef\u7684\u6765\u6e90";
        System.out.println("str: " + str);
        String gbk = EncodeUtil.toGBK(str);
        System.out.println("\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String ascii = EncodeUtil.toASCII(str);
        System.out.println("\u8f6c\u6362\u6210US-ASCII\u7801: " + ascii);
        gbk = EncodeUtil.changeCharset(ascii, US_ASCII, GBK);
        System.out.println("\u518d\u628aASCII\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String iso88591 = EncodeUtil.toISO_8859_1(str);
        System.out.println("\u8f6c\u6362\u6210ISO-8859-1\u7801: " + iso88591);
        gbk = EncodeUtil.changeCharset(iso88591, ISO_8859_1, GBK);
        System.out.println("\u518d\u628aISO-8859-1\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String utf8 = EncodeUtil.toUTF_8(str);
        System.out.println("\u8f6c\u6362\u6210UTF-8\u7801: " + utf8);
        gbk = EncodeUtil.changeCharset(utf8, UTF_8, GBK);
        System.out.println("\u518d\u628aUTF-8\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String utf16be = EncodeUtil.toUTF_16BE(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16BE\u7801:" + utf16be);
        gbk = EncodeUtil.changeCharset(utf16be, UTF_16BE, GBK);
        System.out.println("\u518d\u628aUTF-16BE\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String utf16le = EncodeUtil.toUTF_16LE(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16LE\u7801:" + utf16le);
        gbk = EncodeUtil.changeCharset(utf16le, UTF_16LE, GBK);
        System.out.println("\u518d\u628aUTF-16LE\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        System.out.println();
        String utf16 = EncodeUtil.toUTF_16(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16\u7801:" + utf16);
        gbk = EncodeUtil.changeCharset(utf16, UTF_16LE, GBK);
        System.out.println("\u518d\u628aUTF-16\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk);
        String s = new String("\u4e2d\u6587".getBytes(UTF_8), UTF_8);
        System.out.println(s);
    }
}

