/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.http;

import cn.eova.tools.x;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUtils {
    private static final String TYPE_JSON = "application/json";
    private static final String TYPE_XML = "application/xml";
    private static final String TYPE_SAOP = "application/soap+xml";
    private static final String TYPE_TEXT = "text/plain";
    private static final String TYPE_BYTE = "application/octet-stream";
    private String charSet = "UTF-8";
    private String contentType = "application/x-www-form-urlencoded";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final SSLSocketFactory sslSocketFactory = HttpUtils.initSSLSocketFactory();
    private static final TrustAnyHostnameVerifier trustAnyHostnameVerifier;

    private HttpUtils() {
    }

    private HttpUtils(String charSet) {
        this.charSet = charSet;
    }

    public static HttpUtils cs() {
        return new HttpUtils();
    }

    public static HttpUtils cs(String charSet) {
        return new HttpUtils(charSet);
    }

    private static SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] trustManagerArray = new TrustManager[1];
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.getClass();
            trustManagerArray[0] = httpUtils.new TrustAnyTrustManager();
            TrustManager[] tm = trustManagerArray;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpURLConnection getHttpConnection(String url, String method, Map<String, String> headers, String contentType) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        URL _url = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)_url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier(trustAnyHostnameVerifier);
        }
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHttpOk(String url) {
        if (!url.contains("http")) {
            url = "http://" + url;
        }
        HttpURLConnection conn = null;
        try {
            URL serverUrl = new URL(url);
            conn = (HttpURLConnection)serverUrl.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod(GET);
            conn.connect();
            int state = conn.getResponseCode();
            if (state == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            conn.disconnect();
        }
        return false;
    }

    public String get(String url, Map<String, String> queryParas, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            conn = HttpUtils.getHttpConnection(this.buildUrlWithQueryString(url, queryParas), GET, headers, this.contentType);
            conn.connect();
            String string = this.readResponseString(conn);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public String get(String url, Map<String, String> queryParas) {
        return this.get(url, queryParas, null);
    }

    public String get(String url) {
        return this.get(url, null, null);
    }

    public String post(String url, Map<String, String> queryParas, String data, Map<String, String> headers) {
        try {
            return this.post(url, queryParas, data.getBytes(this.charSet), headers);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String post(String url, Map<String, String> queryParas, byte[] bt, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            conn = HttpUtils.getHttpConnection(this.buildUrlWithQueryString(url, queryParas), POST, headers, this.contentType);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            out.write(bt);
            out.flush();
            out.close();
            String string = this.readResponseString(conn);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public String post(String url, Map<String, String> queryParas, String data) {
        return this.post(url, queryParas, data, null);
    }

    public String post(String url, String data, Map<String, String> headers) {
        return this.post(url, null, data, headers);
    }

    public String post(String url, String data) {
        return this.post(url, null, data, null);
    }

    public String post(String url, Map<String, String> dataParas) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : dataParas.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key).append("=").append(value);
        }
        return this.post(url, null, sb.toString(), null);
    }

    private String readResponseString(HttpURLConnection conn) {
        StringBuilder sb = new StringBuilder();
        InputStream inputStream = null;
        try {
            inputStream = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.charSet));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    x.log.error(e.getMessage(), e);
                }
            }
        }
    }

    private String buildUrlWithQueryString(String url, Map<String, String> queryParas) {
        boolean isFirst;
        if (queryParas == null || queryParas.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            isFirst = true;
            sb.append("?");
        } else {
            isFirst = false;
        }
        for (Map.Entry<String, String> entry : queryParas.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (!x.isEmpty(value)) {
                try {
                    value = URLEncoder.encode(value, this.charSet);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public String postJson(String url, String json) {
        this.contentType = TYPE_JSON;
        return this.post(url, null, json, null);
    }

    public String postFile(String url, byte[] bytes) {
        this.contentType = TYPE_BYTE;
        return this.post(url, null, bytes, null);
    }

    public String postText(String url, String text) {
        this.contentType = TYPE_TEXT;
        return this.post(url, null, text, null);
    }

    public String postXml(String url, String xml) {
        this.contentType = TYPE_XML;
        return this.post(url, null, xml, null);
    }

    public String postSoap(String url, String soap) {
        this.contentType = TYPE_SAOP;
        return this.post(url, null, soap, null);
    }

    static {
        HttpUtils httpUtils = new HttpUtils();
        httpUtils.getClass();
        trustAnyHostnameVerifier = httpUtils.new TrustAnyHostnameVerifier();
    }

    private class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

