/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public class FileUtil {
    public static final String IMG_TYPE = ".jpg|.gif|.png|.bmp";
    public static String ALL_TYPE = ".jpg|.jepg|.gif|.png|.bmp|.gz|.7z|.rar|.zip|.swf|.mp3|.mp4|.jar|.apk|.ipa|.doc|.docx|.xls|.xlsx|.ppt|.pptx|.pdf|.txt";

    public static String formatPath(String path) {
        if (path.contains("/")) {
            path = path.replace("/", File.separator);
        }
        if (path.contains("\\")) {
            path = path.replace("/", File.separator);
        }
        return path;
    }

    public static boolean checkFileSize(File file, int kb) {
        long size = file.length();
        return size > (long)(1024 * kb);
    }

    public static boolean checkFileType(String fileName, boolean isImg) {
        String fileType = FileUtil.getFileType(fileName);
        if (isImg) {
            return IMG_TYPE.indexOf(fileType.toLowerCase()) != -1;
        }
        return ALL_TYPE.indexOf(fileType.toLowerCase()) != -1;
    }

    public static boolean isImg(String fileName) {
        String fileType = FileUtil.getFileType(fileName);
        return IMG_TYPE.indexOf(fileType.toLowerCase()) != -1;
    }

    public static String getFileType(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."), fileName.length());
    }

    public static boolean isExists(String path) {
        File file = new File(path);
        return file.exists() && file.length() > 0L;
    }

    public static boolean isDir(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static void delete(String path) {
        FileUtil.delete(new File(path));
    }

    public static void delete(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static void rename(String path, String toPath) throws IOException {
        File toBeRenamed = new File(path);
        if (!toBeRenamed.exists() || toBeRenamed.isDirectory()) {
            throw new IOException("File does not exist: " + path);
        }
        File newFile = new File(toPath);
        if (!toBeRenamed.renameTo(newFile)) {
            throw new IOException("rename error");
        }
    }

    public static File[] getFiles(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.listFiles();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProp(File file) throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)is, "UTF-8"));
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProp(URL url) throws Exception {
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = url.openStream();
            props.load(new InputStreamReader(is, "UTF-8"));
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.formatPath("C:\\static\\img/product"));
        System.out.println(FileUtil.formatPath("C:/static/img/product"));
        System.out.println(FileUtil.formatPath("home/static/img/product"));
    }
}

