/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<String> findjarFiles(String baseDirName, final List<String> includeJars) {
        ArrayList<String> classFiles = new ArrayList<String>();
        try {
            File baseDir = new File(baseDirName);
            if (baseDir.exists() && baseDir.isDirectory()) {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return includeJars.contains(name);
                    }
                });
                for (int i = 0; i < filelist.length; ++i) {
                    JarFile localJarFile = new JarFile(new File(baseDirName + File.separator + filelist[i]));
                    Enumeration<JarEntry> entries = localJarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                        String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
                        classFiles.add(className);
                    }
                    localJarFile.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    public static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> classFiles = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.err.println("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassUtil.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
                    continue;
                }
                tempName = readfile.getName();
                if (!ClassUtil.wildcardMatch(targetFileName, tempName)) continue;
                String tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                String classname = tem.substring(tem.indexOf("/classes") + "/classes".length(), tem.indexOf(".class"));
                if (classname.startsWith("/")) {
                    classname = classname.substring(classname.indexOf("/") + 1);
                }
                classname = ClassUtil.className(classname, "/classes");
                classFiles.add(classname);
            }
        }
        return classFiles;
    }

    public static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static String className(String classFile, String pre) {
        String objStr = classFile.replaceAll("\\\\", "/");
        return objStr.replaceAll("/", ".");
    }

    public static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList<Class<T>> classList = new ArrayList<Class<T>>();
        for (String classFile : classFileList) {
            Class<?> cs = null;
            try {
                cs = Class.forName(classFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!clazz.isAssignableFrom(cs) || clazz == cs) continue;
            classList.add(cs);
        }
        return classList;
    }
}

