/*
 * Decompiled with CFR 0.152.
 */
package cn.eova.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GZipUtils {
    public static byte[] compress(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data);
        gzip.close();
        return out.toByteArray();
    }

    public static byte[] compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return null;
        }
        return GZipUtils.compress(str.getBytes("utf-8"));
    }

    public static byte[] uncompress(byte[] data) throws IOException {
        int n;
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        GZIPInputStream gunzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = gunzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        gunzip.close();
        in.close();
        return out.toByteArray();
    }

    public static String uncompress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        byte[] data = GZipUtils.uncompress(str.getBytes("utf-8"));
        return new String(data);
    }

    public static String unZip(String unZipfile, String destFile) {
        String inData = null;
        try {
            File f = new File(unZipfile);
            ZipFile zipFile = new ZipFile(f);
            ZipEntry entry = zipFile.getEntry(destFile);
            if (!entry.isDirectory()) {
                InputStream inputStream = zipFile.getInputStream(entry);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] bys = new byte[4096];
                int p = -1;
                while ((p = inputStream.read(bys)) != -1) {
                    out.write(bys, 0, p);
                }
                inData = out.toString();
                out.close();
                inputStream.close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return inData;
    }
}

