/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.eova.ifs.bean;

import java.util.HashMap;
import java.util.Map;

/**
 * 统一使用
 *
 * @author Jieven
 */
@SuppressWarnings({"serial", "rawtypes", "unchecked"})
public class Rpc extends HashMap  {

    private static final long serialVersionUID = -3021472182023759198L;

    private static final String STATE = "_state";
    private static final String MSG = "_msg";
    private static final String JSON = "_json";

    /**
     * 业务正常
     * @return
     */
    public static Rpc ok() {
        Rpc e = new Rpc();
        e.set(STATE, true);
        return e;
    }

    /**
     * 业务正常
     * @param json 业务数据(JSON字符串)
     * @return
     */
    public static Rpc ok(String json) {
        Rpc e = new Rpc();
        e.set(STATE, true);
        e.set(JSON, json);
        return e;
    }

    /**
     * 业务异常
     * @param msg 异常提示
     * @return
     */
    public static Rpc no(String msg) {
        Rpc e = new Rpc();
        e.set(STATE, false);
        e.set(MSG, msg);
        return e;
    }



    public boolean isOk() {
        return this.getBoolean(STATE) == true;
    }

    public boolean isNo() {
        return this.getBoolean(STATE) == false;
    }

    public String getMsg() {
        return this.getStr(MSG);
    }

    public Rpc set(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    public Rpc delete(Object key) {
        super.remove(key);
        return this;
    }

    public Rpc set(Map map) {
        super.putAll(map);
        return this;
    }

    public String getStr(Object key) {
        Object s = get(key);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(Object key) {
        Number n = (Number)get(key);
        return n != null ? n.intValue() : null;
    }

    public Long getLong(Object key) {
        Number n = (Number)get(key);
        return n != null ? n.longValue() : null;
    }

    public Double getDouble(Object key) {
        Number n = (Number)get(key);
        return n != null ? n.doubleValue() : null;
    }

    public Float getFloat(Object key) {
        Number n = (Number)get(key);
        return n != null ? n.floatValue() : null;
    }

    public Number getNumber(Object key) {
        return (Number)get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)get(key);
    }

    /**
     * key 存在，并且 value 不为 null
     */
    public boolean notNull(Object key) {
        return get(key) != null;
    }

    /**
     * key 不存在，或者 key 存在但 value 为null
     */
    public boolean isNull(Object key) {
        return get(key) == null;
    }

    /**
     * key 存在，并且 value 为 true，则返回 true
     */
    public boolean isTrue(Object key) {
        Object value = get(key);
        return (value instanceof Boolean && ((Boolean)value == true));
    }

    /**
     * key 存在，并且 value 为 false，则返回 true
     */
    public boolean isFalse(Object key) {
        Object value = get(key);
        return (value instanceof Boolean && ((Boolean)value == false));
    }

    public boolean equals(Object rpc) {
        return rpc instanceof Rpc && super.equals(rpc);
    }

}