/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.ifs.base;

/**
 * 枚举命名强约束接口
 * <p>
 * 如果View是纯Enjoy 你的枚举命名是和接口一致(val + txt), 可以不用实现本接口
 * 但是属性需要开放成public, 否则Enjoy 无法取值
 * <pre>
 *  public int val;
 *  public String txt;
 * </pre>
 */
public interface BaseEnum {

    int getVal();

    void setVal(int val);

    String getTxt();

    void setTxt(String txt);

//    子类必须实现valueOf重载, 方便根据 val 获取枚举
//    public static XxxxEnum valueOf(int val) {
//        return Stream.of(XxxxEnum.values()).filter(r -> r.getVal() == val).findAny().orElse(null);
//    }

//    常用Model绑定枚举代码

//    public B2bApplyStatus getStatus() {
//        return B2bApplyStatus.valueOf(this.getInt("status"));
//    }
//
//    public void setStatus(B2bApplyStatus status) {
//        this.set("status", status.getVal());
//    }


//    public B2bBizType getType() {
//        return B2bBizType.valueOf(this.getInt("type"));
//    }
//
//    public void setType(B2bBizType type) {
//        this.set("type", type.getVal());
//    }
}
