/*
 * Copyright (c) 2023 EOVA.CN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.eova.common.base;

/**
 * 枚举命名强约束接口
 *
 * 如果View是纯Enjoy 你的枚举命名是和接口一致(val + txt), 可以不用实现本接口
 * 但是属性需要开放成public, 否则Enjoy 无法取值
 * <pre>
 *  public int val;
 *  public String txt;
 * </pre>
 */
public interface BaseEnum {

    int getVal();

    void setVal(int val);

    String getTxt();

    void setTxt(String txt);

}
