package com.enited.union.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatImageView;

import com.enited.union.R;

/**
 * author : ZhengYuanle
 * time   : 2022/9/21
 * desc   : 自定义标题栏
 */
public class MyTitleBar extends RelativeLayout {

    //返回
    private RelativeLayout rl_title_left, rl_title_contain;
    //标题
    private TextView tv_title, tv_right;


    public MyTitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        View.inflate(context, R.layout.layout_title_bar, MyTitleBar.this);
        initView();
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.MyTitleBar);
        String titleText = array.getString(R.styleable.MyTitleBar_title_bar_text);
        boolean isLeftShow = array.getBoolean(R.styleable.MyTitleBar_title_bar_is_left_show, true);
        boolean isBgWhite = array.getBoolean(R.styleable.MyTitleBar_title_bar_is_bg_white, true);
        int titleColor = array.getResourceId(R.styleable.MyTitleBar_title_bar_title_color, Color.parseColor("#000000"));

        if (!TextUtils.isEmpty(titleText)) {
            tv_title.setText(titleText);
        }
        if (isLeftShow) {
            rl_title_left.setVisibility(VISIBLE);
        } else {
            rl_title_left.setVisibility(INVISIBLE);
        }
        if (isBgWhite) {
            setBackgroundColor(Color.parseColor("#FFFFFF"));
        }
        setTitleColor(titleColor);
        //释放TypedArray
        array.recycle();
    }


    private void initView() {
        rl_title_left = findViewById(R.id.rl_title_left);
        tv_title = findViewById(R.id.tv_title);
        rl_title_contain = findViewById(R.id.rl_title_contain);
        tv_right = findViewById(R.id.tv_right);
    }

    public void setTitle(String title) {
        tv_title.setText(title);
    }

    public void setTitle(int resId) {
        setTitle(getResources().getString(resId));
    }

    public void setTitleColor(int textColor) {
        tv_title.setTextColor(textColor);
    }

    public void setBackgroundColor(int textColor) {
        rl_title_contain.setBackgroundColor(textColor);
    }

    public void setLeftClickListener(View.OnClickListener onClickListener) {
        rl_title_left.setOnClickListener(onClickListener);
    }

    public void setRightTextVisible(boolean isShow) {
        if (isShow) {
            tv_right.setVisibility(View.VISIBLE);
        } else {
            tv_right.setVisibility(View.GONE);
        }
    }

    public void setOnRightTextClick(String text, View.OnClickListener onClickListener) {
        tv_right.setVisibility(View.VISIBLE);
        tv_right.setText(text);
        tv_right.setOnClickListener(onClickListener);
    }

    public void setRightText(String text) {
        tv_right.setVisibility(View.VISIBLE);
        if (TextUtils.isEmpty(text)) {
            tv_right.setText("");
        } else {
            tv_right.setText(text);
        }

    }

    public void setOnRightTextClick(View.OnClickListener onClickListener) {
        tv_right.setVisibility(View.VISIBLE);
        tv_right.setOnClickListener(onClickListener);
    }

    public void setOnRightTextClick(int textColorId, String text, View.OnClickListener onClickListener) {
        tv_right.setVisibility(View.VISIBLE);
        tv_right.setTextColor(textColorId);
        tv_right.setText(text);
        tv_right.setOnClickListener(onClickListener);
    }

}
