package com.enited.union.utils;

import android.app.Activity;
import android.content.Context;
import android.view.Gravity;
import android.widget.TextView;
import android.widget.Toast;

import com.enited.union.EnitedUnionSDKManager;
import com.enited.union.R;

/**
 * author : ZhengYuanle
 * time   : 2022/9/21
 * desc   : 封装Toast
 */
public class ToastUtils {
    /**
     * 这里是方法的重载，用于开放不同的参数
     */
    public static void showToast(int messageID) {
        showToast(EnitedUnionSDKManager.getApp(), messageID);
    }


    public static void showToast(String message) {
        showToast(EnitedUnionSDKManager.getApp(), message);
    }


    public static void showToast(int messageID, int duration) {
        showToast(EnitedUnionSDKManager.getApp(), messageID, duration);
    }

    public static void showToast(String message, int duration) {
        showToast(EnitedUnionSDKManager.getApp(), message, duration);
    }


    public static void showToast(Context context, int resId) {
        showToast(context, context.getString(resId), Toast.LENGTH_SHORT);
    }

    public static void showToast(Context context, String message) {
        showToast(context, message, Toast.LENGTH_SHORT);
    }

    public static void showToast(Activity context, int resId) {
        showToast(context, context.getString(resId), Toast.LENGTH_SHORT);
    }

    public static void showToast(Activity context, int resId, int duration) {
        showToast(context, context.getString(resId), duration);
    }

    private static void showToast(Activity context, String message) {
        showToast(context, message, Toast.LENGTH_SHORT);
    }


    private static void showToast(Context context, int resId, int duration) {
        showToast(context, context.getString(resId), duration);
    }

    private static Toast toast;
    private static TextView contentView;

    /**
     * 自定义Toast的样式与位置
     */
    private static void showToast(Context context, String message, int duration) {
        if (context == null) {
            return;
        }
        try {
            if (toast == null || contentView == null) {
                int dp30 = context.getResources().getDimensionPixelSize(R.dimen.dp_15);
                int dp20 = context.getResources().getDimensionPixelSize(R.dimen.dp_10);
                contentView = new TextView(context);
                contentView.setGravity(Gravity.CENTER);
                contentView.setBackgroundResource(R.drawable.bg_toast);
                contentView.setTextSize(14);
                contentView.setTextColor(context.getResources().getColor(R.color.white));
                contentView.setPadding(dp30, dp20, dp30, dp20);
                toast = new Toast(context);
                toast.setGravity(Gravity.BOTTOM, 0, context.getResources().getDimensionPixelSize(R.dimen.dp_100));
                toast.setView(contentView);
                toast.setDuration(duration);
            }
            contentView.setText(message);
            toast.show();
        } catch (Exception e) {
            Toast.makeText(context, message, duration).show();
            e.printStackTrace();
        }
    }
}
