package com.enited.union.utils;

import static android.content.Context.MODE_PRIVATE;

import android.content.SharedPreferences;
import android.text.TextUtils;

import com.enited.union.EnitedUnionSDKManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.List;

/**
 * author : ZhengYuanle
 * time   : 2022/6/28
 * desc   : sp工具类封装
 */
public class SpUtils {

    private static final String SP_FILE_KEY = "com.enited.union.shared_preferences";
    private static SpUtils spUtil;
    private static SharedPreferences sp;

    private static SpUtils getSpUtil() {
        if (spUtil == null || sp == null) {
            spUtil = new SpUtils(SpUtils.SP_FILE_KEY);
        }
        return spUtil;
    }

    public static SpUtils getSpUtils() {
        return getSpUtil();
    }

    private SpUtils(String fileKey) {
        sp = EnitedUnionSDKManager.getApp().getSharedPreferences(fileKey, MODE_PRIVATE);
    }

    public void putValue(String valueKey, String value) {
        SharedPreferences.Editor edit = sp.edit();
        edit.putString(valueKey, value);
        edit.apply();
    }

    public void putValue(String valueKey, int value) {
        SharedPreferences.Editor edit = sp.edit();
        edit.putInt(valueKey, value);
        edit.apply();
    }

    public void putValue(String valueKey, float value) {
        SharedPreferences.Editor edit = sp.edit();
        edit.putFloat(valueKey, value);
        edit.apply();
    }

    public void putValue(String valueKey, boolean value) {
        SharedPreferences.Editor edit = sp.edit();
        edit.putBoolean(valueKey, value);
        edit.apply();
    }

    public void putValue(String valueKey, long value) {
        SharedPreferences.Editor edit = sp.edit();
        edit.putLong(valueKey, value);
        edit.apply();
    }


    public String getValue(String valueKey, String defaultValue) {
        return sp.getString(valueKey, defaultValue);
    }

    public int getValue(String valueKey, int defaultValue) {
        return sp.getInt(valueKey, defaultValue);
    }

    public float getValue(String valueKey, float defaultValue) {
        return sp.getFloat(valueKey, defaultValue);
    }

    public boolean getValue(String valueKey, boolean defaultValue) {
        return sp.getBoolean(valueKey, defaultValue);
    }

    public long getValue(String valueKey, long defaultValue) {
        return sp.getLong(valueKey, defaultValue);
    }

    /**
     * 保存List
     */
    public <T> void putSPList(String key, List<T> list) {
        SharedPreferences.Editor edit = sp.edit();
        if (null == list || list.size() <= 0) {
            edit.putString(key, "");
            return;
        }
        //转换成json数据，再保存
        String strJson = new Gson().toJson(list);
        edit.putString(key, strJson);
        edit.apply();
    }

    /**
     * 获取List
     */
    public <T> List<T> getSPList(String tag) {
        List<T> list = new ArrayList<T>();
        String strJson = sp.getString(tag, null);
        if (TextUtils.isEmpty(strJson)) {
            return list;
        }
        list = new Gson().fromJson(strJson, new TypeToken<List<T>>() {
        }.getType());
        return list;
    }

}
