package com.enited.union.utils;

/**
 * author : ZhengYuanle
 * time   : 2022/9/20
 * desc   : 用户数据相关工具
 */
public class AccountUtils {
    private static volatile AccountUtils sInstance = null;
    private final SpUtils spUtils;


    private final String USER_TOKEN_KEY = "user_token_key";


    //*********token******************
    public void saveToken(String token) {
        spUtils.putValue(USER_TOKEN_KEY, token);
    }

    public String getToken() {
        return spUtils.getValue(USER_TOKEN_KEY, "");
    }


    public static AccountUtils getInstance() {
        if (sInstance == null) {
            synchronized (AccountUtils.class) {
                if (sInstance == null) {
                    sInstance = new AccountUtils();
                }
            }
        }
        return sInstance;
    }

    public AccountUtils() {
        spUtils = SpUtils.getSpUtils();
    }
}
