package com.enited.union.ui.adapter;

import android.content.Context;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;

import com.enited.union.R;
import com.enited.union.app.AppAdapter;
import com.enited.union.http.glide.GlideApp;

/**
 * author : ZhengYuanle
 * time   : 2022/6/28
 * desc   : 图片预览适配器
 */
public final class ImagePreviewAdapter extends AppAdapter<String> {

    public ImagePreviewAdapter(Context context) {
        super(context);
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder();
    }

    private final class ViewHolder extends AppAdapter<?>.ViewHolder {

        private final AppCompatImageView mPhotoView;

        private ViewHolder() {
            super(R.layout.item_image_preview);
            mPhotoView = (AppCompatImageView) getItemView();
        }

        @Override
        public void onBindView(int position) {
            GlideApp.with(getContext())
                    .load(getItem(position))
                    .into(mPhotoView);
        }
    }
}