package com.enited.union.ui.activity;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.app.ActivityCompat;

import com.enited.union.EnitedUnionSDKManager;
import com.enited.union.R;
import com.enited.union.app.AppActivity;
import com.enited.union.app.CallBackInstance;
import com.enited.union.entity.IdCardOcrEntity;
import com.enited.union.entity.IndivIdentityUrlRespEntity;
import com.enited.union.entity.UserDetailsEntity;
import com.enited.union.http.api.CreateEsignAccountApi;
import com.enited.union.http.api.GetIdentityUrlApi;
import com.enited.union.http.api.IdCardOCRApi;
import com.enited.union.http.api.UserDetailsApi;
import com.enited.union.http.glide.GlideApp;
import com.enited.union.http.model.HttpData;
import com.enited.union.listener.OnResultListener;
import com.enited.union.view.RatioImageView;
import com.enited.union.view.SettingBar;
import com.esign.esignsdk.data.AuthEvent;
import com.hjq.http.EasyHttp;
import com.hjq.http.listener.HttpCallback;
import com.hjq.http.listener.OnUpdateListener;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.File;

import okhttp3.Call;
import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

/**
 * author : ZhengYuanle
 * time   : 2022/9/20
 * desc   : 人脸识别
 */
public final class UserCertificationActivity extends AppActivity {

    private RatioImageView ivIdCardNationalEmblem;
    private RatioImageView ivIdCardPortrait;
    private AppCompatTextView tvErrorTip;
    private AppCompatTextView etAddress;
    private Button btnOpen;
    private SettingBar sbName;
    private SettingBar sbIdCard;
    private SettingBar sbDateOfIssue;
    private SettingBar sbValidityOfCertificate;
    private SettingBar sbIssueAuthority;
    private SettingBar sbPhone;
    private SettingBar sbAuthStatus;

    private UserDetailsEntity userDetailsEntity;

    private OnResultListener mOnResultListener = null;

    @Override
    protected boolean regEvent() {
        return true;
    }


    public static void start(Context context) {
        Intent intent = new Intent(context, UserCertificationActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    public static void start(Context context, OnResultListener listener) {
        CallBackInstance.getInstance().setOnResultListener(listener);
        Intent intent = new Intent(context, UserCertificationActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }


    @Override
    protected int getLayoutId() {
        return R.layout.activity_user_certification;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void processResult(AuthEvent event) {
        toast("实名认证成功");
        EnitedUnionSDKManager.closeH5Activity();
        if (mOnResultListener != null) {
            mOnResultListener.onSuccess();
        }
        UserCertificationActivity.this.finish();
    }


    @Override
    protected void initView() {

        mOnResultListener = CallBackInstance.getInstance().getOnResultListener();

        tvErrorTip = findViewById(R.id.tv_error_tip);
        ivIdCardNationalEmblem = findViewById(R.id.iv_id_card_national_emblem);
        ivIdCardPortrait = findViewById(R.id.iv_id_card_portrait);
        sbName = findViewById(R.id.sb_name);
        sbIdCard = findViewById(R.id.sb_id_card);
        sbDateOfIssue = findViewById(R.id.sb_date_of_issue);
        sbValidityOfCertificate = findViewById(R.id.sb_validity_of_certificate);
        sbIssueAuthority = findViewById(R.id.sb_issue_authority);
        etAddress = findViewById(R.id.et_address);
        sbPhone = findViewById(R.id.sb_phone);
        sbAuthStatus = findViewById(R.id.sb_auth_status);
        btnOpen = findViewById(R.id.btn_open);

        mTitleBar.setLeftClickListener(v -> onBackPressed());

        setOnClickListener(btnOpen, ivIdCardNationalEmblem, ivIdCardPortrait);
    }

    @Override
    protected void initData() {
//        getUserDetails();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 0x100) {
            //相机权限
            if (hasPermissions(Manifest.permission.CAMERA)) {
                startIdentity();
            } else {
                toast("人脸识别需要开启摄像头权限,请前往设置中开启");
            }
        }else if (requestCode == 0x101){
            if (hasPermissions(Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                startImageSelect(1);
            } else {
                toast("上传身份证需要开启摄像头及存储权限，请前往设置中开启");
            }
        }else if (requestCode == 0x102){
            if (hasPermissions(Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                startImageSelect(2);
            } else {
                toast("上传身份证需要开启摄像头及存储权限，请前往设置中开启");
            }
        }
    }

    @Override
    public void onClick(View view) {
        if (view == btnOpen) {
            //权限判断
            if (hasPermissions(Manifest.permission.CAMERA)) {
                startIdentity();
            } else {
                String[] permissions = new String[]{Manifest.permission.CAMERA};
                ActivityCompat.requestPermissions(this, permissions, 0x100);
            }
            toast("获取用户信息失败，请退出重试");
            if (mOnResultListener != null) {
                mOnResultListener.onSuccess();
            }
            UserCertificationActivity.this.finish();
        } else if (view == ivIdCardNationalEmblem) {
            //国徽面

            if (userDetailsEntity == null) {
                toast("获取用户信息失败，请退出重试");
                return;
            }
            int authStatus = userDetailsEntity.getRealAuthState();
            if (TextUtils.isEmpty(userDetailsEntity.getIdCardJustP()) || authStatus == 0) {
                if (hasPermissions(Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                    startImageSelect(2);
                } else {
                    requestPermissions(0x102, Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE);
                }
            }

        } else if (view == ivIdCardPortrait) {
            //人像面
            if (userDetailsEntity == null) {
                toast("获取用户信息失败，请退出重试");
                return;
            }
            //人脸识别 0 未识别  1已识别
            int authStatus = userDetailsEntity.getRealAuthState();
            if (TextUtils.isEmpty(userDetailsEntity.getIdCardBackP()) || authStatus == 0) {
                if (hasPermissions(Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                    startImageSelect(1);
                } else {
                    requestPermissions(0x101, Manifest.permission.CAMERA, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE);
                }
            }
        }
    }

    private void startImageSelect(int idCardType) {
        ImageSelectActivity.start(this, data -> {
            String path = data.get(0);
            compressImage(idCardType, path);
        });
    }

    private void startIdentity() {
        //信息是否齐全
        boolean isCanNext = checkCanNext();
        if (isCanNext) {
            //当前用户是否已注册E签宝账号，若是直接发起人脸识别，否则调用创建E签宝账号接口
            String name = sbName.getRightText().toString();
            String idNumber = sbIdCard.getRightText().toString();
            String mobile = sbPhone.getRightText().toString();
            if (TextUtils.isEmpty(userDetailsEntity.getAccountId())) {
                createEsignAccount(name, idNumber, mobile);
            } else {
                getIdentityUrl(userDetailsEntity.getAccountId());
            }
        }
    }


    /**
     * 检查数据是否为空
     */
    private boolean checkCanNext() {
        String name = sbName.getRightText().toString();
        String idNumber = sbIdCard.getRightText().toString();
        String startTime = sbDateOfIssue.getRightText().toString();
        String endTime = sbValidityOfCertificate.getRightText().toString();
        String issueBy = sbIssueAuthority.getRightText().toString();
        String address = etAddress.getText().toString();
        String mobile = sbPhone.getRightText().toString();

        if (TextUtils.isEmpty(name)) {
            toast("姓名不能为空");
            return false;
        }
        if (TextUtils.isEmpty(idNumber)) {
            toast("证件号码不能为空");
            return false;
        }
        if (TextUtils.isEmpty(startTime)) {
            toast("证件签发日不能为空");
            return false;
        }
        if (TextUtils.isEmpty(endTime)) {
            toast("证件有效期不能为空");
            return false;
        }
        if (TextUtils.isEmpty(issueBy)) {
            toast("发证机关不能为空");
            return false;
        }
        if (TextUtils.isEmpty(address)) {
            toast("用户住址不能为空");
            return false;
        }
        if (TextUtils.isEmpty(mobile)) {
            toast("手机号不能为空");
            return false;
        }

        return true;
    }

    /**
     * 获取实名认证URL
     */
    private void getIdentityUrl(String accountId) {
        //信息是否齐全
        boolean isCanNext = checkCanNext();
        if (isCanNext) {
            String name = sbName.getRightText().toString();
            String idNumber = sbIdCard.getRightText().toString();
            String mobile = sbPhone.getRightText().toString();

            GetIdentityUrlApi.ContextInfoEntity contextInfo = new GetIdentityUrlApi.ContextInfoEntity();
            contextInfo.setContextId(accountId);

            GetIdentityUrlApi.IndivInfoEntity indivInfo = new GetIdentityUrlApi.IndivInfoEntity();
            indivInfo.setCertNo(idNumber);
            indivInfo.setName(name);
            indivInfo.setMobileNo(mobile);

            EasyHttp.post(this)
                    .api(new GetIdentityUrlApi()
                            .setAccountId(accountId)
                            .setContextInfo(contextInfo)
                            .setIndivInfo(indivInfo)
                    )
                    .request(new HttpCallback<HttpData<IndivIdentityUrlRespEntity>>(this) {
                        @Override
                        public void onSucceed(HttpData<IndivIdentityUrlRespEntity> result) {
                            IndivIdentityUrlRespEntity entity = result.getData();
                            EnitedUnionSDKManager.goSign(UserCertificationActivity.this, entity.getShortLink());
                        }
                    });

        }
    }

    /**
     * 创建E签宝账号
     */
    private void createEsignAccount(String name, String idNumber, String mobile) {
        EasyHttp.post(this)
                .api(new CreateEsignAccountApi()
                        .setIdType()
                        .setIdNumber(idNumber)
                        .setMobile(mobile)
                        .setName(name))
                .request(new HttpCallback<HttpData<String>>(this) {

                    @Override
                    public void onSucceed(HttpData<String> result) {
                        String accountId = result.getData();
                        if (TextUtils.isEmpty(accountId)) {
                            toast("账号创建失败");
                            return;
                        }
                        //需要刷新accountId
                        userDetailsEntity.setAccountId(accountId);
                        getIdentityUrl(accountId);
                    }
                });
    }

    /**
     * 图片上传
     *
     * @param idCardType 1 人像页面 2国徽页
     * @param file       压缩后图片文件
     */
    private void idCardOCR(int idCardType, File file) {

        IdCardOCRApi idCardOCRApi;

        if (idCardType == 1) {
            idCardOCRApi = new IdCardOCRApi().setInfoImg(file);
        } else {
            idCardOCRApi = new IdCardOCRApi().setEmblemImg(file);
        }

        EasyHttp.post(this)
                .api(idCardOCRApi)
                .request(new OnUpdateListener<HttpData<IdCardOcrEntity>>() {

                    @Override
                    public void onStart(Call call) {
                        showDialog();
                    }

                    @Override
                    public void onSucceed(HttpData<IdCardOcrEntity> result) {
                        IdCardOcrEntity entity = result.getData();
                        if (idCardType == 1) {
                            if (TextUtils.isEmpty(entity.getName())) {
                                toast("请上传身份证人像面");
                                return;
                            }
                            GlideApp.with(getContext())
                                    .asBitmap()
                                    .load(file)
                                    .error(R.mipmap.pic_id_card_error)
                                    .into(ivIdCardPortrait);
                        } else {
                            if (TextUtils.isEmpty(entity.getValidityPeriod())) {
                                toast("请上传身份证国徽面");
                                return;
                            }
                            GlideApp.with(getContext())
                                    .asBitmap()
                                    .load(file)
                                    .error(R.mipmap.pic_id_card_error)
                                    .into(ivIdCardNationalEmblem);
                        }
                        if (!TextUtils.isEmpty(entity.getName())) {
                            sbName.setRightText(entity.getName());
                            userDetailsEntity.setRealName(entity.getName());
                        }
                        if (!TextUtils.isEmpty(entity.getIdNo())) {
                            sbIdCard.setRightText(entity.getIdNo());
                            userDetailsEntity.setIdCard(entity.getIdNo());
                        }
                        String validityPeriod = entity.getValidityPeriod();
                        if (!TextUtils.isEmpty(validityPeriod)) {
                            //有效期限，YYYY.MM.DD-YYYY.MM.DD 或 YYYY.MM.DD-长期  2019.01.01-2039.01.01
                            String[] times = validityPeriod.split("-");
                            if (times.length == 2) {
                                sbDateOfIssue.setRightText(times[0]);
                                sbValidityOfCertificate.setRightText(times[1]);
                            }
                        }
                        if (!TextUtils.isEmpty(entity.getIssuedBy()))
                            sbIssueAuthority.setRightText(entity.getIssuedBy());
                        if (!TextUtils.isEmpty(entity.getAddress())) {
                            etAddress.setText(entity.getAddress());
                            userDetailsEntity.setAddress(entity.getAddress());
                        }
                    }

                    @Override
                    public void onFail(Exception e) {
                        toast(e.getMessage());
                    }

                    @Override
                    public void onEnd(Call call) {
                        hideDialog();
                    }

                    @Override
                    public void onProgress(int progress) {

                    }
                });
    }


    /**
     * 获取用户信息
     */
    private void getUserDetails() {
        EasyHttp.get(this)
                .api(new UserDetailsApi())
                .request(new HttpCallback<HttpData<UserDetailsEntity>>(this) {
                    @Override
                    public void onSucceed(HttpData<UserDetailsEntity> result) {
                        userDetailsEntity = result.getData();
                        if (userDetailsEntity == null) {
                            sbAuthStatus.setRightText("");
                            return;
                        }
                        sbPhone.setRightText(userDetailsEntity.getPhone());
                        sbName.setRightText(userDetailsEntity.getRealName());
                        sbIdCard.setRightText(userDetailsEntity.getIdCard());
                        String validityPeriod = userDetailsEntity.getValidityPeriod();
                        if (!TextUtils.isEmpty(validityPeriod)) {
                            //有效期限，YYYY.MM.DD-YYYY.MM.DD 或 YYYY.MM.DD-长期  2019.01.01-2039.01.01
                            String[] times = validityPeriod.split("-");
                            if (times.length == 2) {
                                sbDateOfIssue.setRightText(times[0]);
                                sbValidityOfCertificate.setRightText(times[1]);
                            }
                        }
                        sbIssueAuthority.setRightText(userDetailsEntity.getIssuedBy());
                        etAddress.setText(userDetailsEntity.getAddress());
                        if (!TextUtils.isEmpty(userDetailsEntity.getIdCardBackP())) {
                            GlideApp.with(getContext())
                                    .load(userDetailsEntity.getIdCardBackP())
                                    .error(R.mipmap.pic_id_card_error)
                                    .into(ivIdCardPortrait);
                        }
                        if (!TextUtils.isEmpty(userDetailsEntity.getIdCardJustP())) {
                            GlideApp.with(getContext())
                                    .load(userDetailsEntity.getIdCardJustP())
                                    .error(R.mipmap.pic_id_card_error)
                                    .into(ivIdCardNationalEmblem);
                        }
                        //实名认证状态 0 未认证  1已认证
                        if (userDetailsEntity.getRealAuthState() == 0) {
                            tvErrorTip.setVisibility(View.VISIBLE);
                            sbAuthStatus.setRightText("未认证");
                            btnOpen.setVisibility(View.VISIBLE);
                            EnitedUnionSDKManager.initESign();
                        } else {
                            tvErrorTip.setVisibility(View.GONE);
                            sbAuthStatus.setRightText("认证通过");
                            btnOpen.setVisibility(View.GONE);
                        }
                    }
                });
    }

    /**
     * 图片压缩,采用IO线程进行图片压缩
     *
     * @param idCardType 1 人像页面 2国徽页
     * @param path       图片文件路径
     */
    private void compressImage(int idCardType, String path) {
        Luban.with(this)
                .load(path)
                .ignoreBy(800)
                //缓存压缩图片路径
                .setTargetDir(getCacheDir().getAbsolutePath())
                //设置开启压缩条件
                .filter(path1 -> !(TextUtils.isEmpty(path1) || path1.toLowerCase().endsWith(".gif")))
                .setCompressListener(new OnCompressListener() {
                    @Override
                    public void onStart() {
                        showDialog();
                    }

                    @Override
                    public void onSuccess(File file) {
                        hideDialog();
                        idCardOCR(idCardType, file);
                    }

                    @Override
                    public void onError(Throwable e) {
                        hideDialog();
                        toast(e.getMessage());
                    }
                }).launch();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mOnResultListener = null;
        CallBackInstance.getInstance().setOnResultListener(null);
    }
}
