package com.enited.union.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatButton;
import androidx.constraintlayout.widget.ConstraintLayout;

import com.enited.union.R;
import com.enited.union.app.AppActivity;
import com.enited.union.app.CallBackInstance;
import com.enited.union.entity.MyBankEntity;
import com.enited.union.http.api.LoadBankCardDetailsApi;
import com.enited.union.http.api.UnboundBankCardApi;
import com.enited.union.http.model.HttpData;
import com.enited.union.http.model.HttpListData;
import com.enited.union.listener.OnBankResultListener;
import com.enited.union.ui.dialog.MessageDialog;
import com.hjq.http.EasyHttp;
import com.hjq.http.listener.HttpCallback;

import java.util.List;

/**
 * author : ZhengYuanle
 * time   : 2022/9/22
 * desc   : 我的银行卡 （查询银行卡、解绑银行卡、绑定另起页面）
 */
public class MyBankCardActivity extends AppActivity {

    private OnBankResultListener mOnResultListener = null;

    private LinearLayout llAddBank;
    private ConstraintLayout clBankCard;
    private TextView tvBankName;
    private TextView tvBankNumber;
    private TextView tvUsername;
    private AppCompatButton btnUnbound;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_my_bank_card;
    }

    public static void start(Context context, OnBankResultListener listener) {
        CallBackInstance.getInstance().setOnBankResultListener(listener);
        Intent intent = new Intent(context, MyBankCardActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    @Override
    protected void initView() {
        mOnResultListener = CallBackInstance.getInstance().getOnBankResultListener();

        llAddBank = findViewById(R.id.ll_add_bank);
        clBankCard = findViewById(R.id.cl_bank_card);
        tvBankName = findViewById(R.id.tv_bank_name);
        tvBankNumber = findViewById(R.id.tv_bank_number);
        tvUsername = findViewById(R.id.tv_username);
        btnUnbound = findViewById(R.id.btn_unbound);

        mTitleBar.setLeftClickListener(v -> onBackPressed());

        setOnClickListener(llAddBank, btnUnbound);
    }

    @Override
    protected void initData() {
        loadBankCardDetails();
    }

    @Override
    public void onClick(View view) {
        if (view == llAddBank) {
            //跳转绑定银行卡
            BindBankCardActivity.start(this, () -> {
                mOnResultListener.onBindSuccess();
                loadBankCardDetails();
            });
        } else if (view == btnUnbound) {
            new MessageDialog.Builder(getContext())
                    .setMessage("确定要解绑当前银行卡？")
                    // 确定按钮文本
                    .setConfirm(getString(R.string.common_confirm))
                    // 设置 null 表示不显示取消按钮
                    .setCancel(getString(R.string.common_cancel))
                    .setListener(dialog -> unboundBankCard())
                    .show();
        }
    }

    public void unboundBankCard() {
        EasyHttp.post(this)
                .api(new UnboundBankCardApi())
                .request(new HttpCallback<HttpData<Void>>(this) {
                    @Override
                    public void onSucceed(HttpData<Void> result) {
                        loadBankCardDetails();
                        llAddBank.setVisibility(View.VISIBLE);
                        clBankCard.setVisibility(View.GONE);
                        mOnResultListener.onUnBindSuccess();
                    }
                });
    }


    /**
     * 查询银行卡信息
     */
    private void loadBankCardDetails() {
        EasyHttp.get(this)
                .api(new LoadBankCardDetailsApi())
                .request(new HttpCallback<HttpListData<MyBankEntity>>(this) {
                    @Override
                    public void onSucceed(HttpListData<MyBankEntity> result) {
                        List<MyBankEntity> list = result.getRows();
                        if (list == null || list.size() == 0) {
                            //未绑定
                            llAddBank.setVisibility(View.VISIBLE);
                            clBankCard.setVisibility(View.GONE);
                            return;
                        }
                        MyBankEntity object = result.getRows().get(0);
                        llAddBank.setVisibility(View.GONE);
                        clBankCard.setVisibility(View.VISIBLE);
                        tvBankName.setText(object.getBankName());
                        tvBankNumber.setText(object.getCardNum());
                        tvUsername.setText("aaaaaaaaaaaaa");
                    }

                    @Override
                    public void onFail(Exception e) {
                        super.onFail(e);
                        //未绑定
                        llAddBank.setVisibility(View.VISIBLE);
                        clBankCard.setVisibility(View.GONE);
                    }
                });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mOnResultListener = null;
        CallBackInstance.getInstance().setOnBankResultListener(null);
    }
}
