package com.enited.union.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AnimationUtils;

import androidx.appcompat.widget.AppCompatButton;

import com.enited.union.R;
import com.enited.union.app.AppActivity;
import com.enited.union.app.CallBackInstance;
import com.enited.union.http.api.GetCodeApi;
import com.enited.union.http.api.GetKeyApi;
import com.enited.union.http.api.ResetPwdApi;
import com.enited.union.http.model.HttpData;
import com.enited.union.listener.OnResultListener;
import com.enited.union.manager.InputTextManager;
import com.enited.union.utils.EncryptUtil;
import com.enited.union.view.ClearEditText;
import com.enited.union.view.CountdownView;
import com.enited.union.view.PasswordEditText;
import com.hjq.http.EasyHttp;
import com.hjq.http.listener.HttpCallback;

import java.util.Objects;

import okhttp3.Call;

/**
 * author : ZhengYuanle
 * time   : 2022/9/22
 * desc   : 忘记密码/修改密码
 */
public final class ForgetActivity extends AppActivity {

    private static final String INTENT_KEY_IN_TYPE = "page_type";

    //忘记密码0  修改密码1
    private int pageType;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_forget;
    }

    private OnResultListener mOnResultListener = null;

    /*
     * 忘记密码0  修改密码1
     */
    public static void start(Context context, int type, OnResultListener listener) {
        CallBackInstance.getInstance().setOnResultListener(listener);
        Intent intent = new Intent(context, ForgetActivity.class);
        intent.putExtra(INTENT_KEY_IN_TYPE, type);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    @Override
    protected void initView() {
        mOnResultListener = CallBackInstance.getInstance().getOnResultListener();

        pageType = getInt(INTENT_KEY_IN_TYPE);

        etPhone = findViewById(R.id.et_phone);
        etPassword = findViewById(R.id.et_password);
        etPassword1 = findViewById(R.id.et_password1);
        etCode = findViewById(R.id.et_code);
        mCountdownView = findViewById(R.id.cv_forget_countdown);
        btnConfirm = findViewById(R.id.btn_confirm);

        if (pageType == 0) {
            //忘记密码
            mTitleBar.setTitle("忘记密码");
        } else {
            //修改密码
            mTitleBar.setTitle("修改密码");
        }


        mTitleBar.setLeftClickListener(v -> onBackPressed());

        setOnClickListener(btnConfirm, mCountdownView);

        InputTextManager.with(getActivity())
                .addView(etPhone)
                .addView(etPassword)
                .addView(etPassword1)
                .addView(etCode)
                .setMain(btnConfirm)
                .build();
    }

    @Override
    protected void initData() {

    }

    @Override
    public void onClick(View view) {
        if (view == btnConfirm) {
            String phone = Objects.requireNonNull(etPhone.getText()).toString();
            String password = Objects.requireNonNull(etPassword.getText()).toString();
            String password1 = Objects.requireNonNull(etPassword1.getText()).toString();
            String code = Objects.requireNonNull(etCode.getText()).toString();

            if (TextUtils.isEmpty(phone)) {
                toast(R.string.common_phone_input_hint);
                etPhone.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                return;
            }

            if (password.length() < 6 || password.length() > 18) {
                toast(R.string.common_password_input_error1);
                etPassword.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                return;
            }

            if (!password1.equals(password)) {
                toast(R.string.common_password_input_error2);
                etPassword1.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                return;
            }

            if (TextUtils.isEmpty(code)) {
                toast("请输入验证码!");
                etCode.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                return;
            }

            getForgetKey(password, phone, code);

        } else if (view == mCountdownView) {
            String phone = Objects.requireNonNull(etPhone.getText()).toString();

            String phoneReg = getString(R.string.regex_phone_number);

            if (TextUtils.isEmpty(phone) || !phone.matches(phoneReg)) {
                etPhone.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                toast(R.string.common_phone_input_error);
                return;
            }
            //发送短信
            EasyHttp.post(this)
                    .api(new GetCodeApi().setCheckUser(0).setMobile(phone).setType(2))
                    .request(new HttpCallback<HttpData<Void>>(this) {
                        @Override
                        public void onSucceed(HttpData<Void> result) {
                            toast(R.string.common_code_send_hint);
                            mCountdownView.start();
                        }
                    });
        }
    }

    private void getForgetKey(String password, String phone, String code) {
        EasyHttp.get(this)
                .api(new GetKeyApi())
                .request(new HttpCallback<HttpData<String>>(null) {
                    @Override
                    public void onStart(Call call) {
                        showDialog();
                    }

                    @Override
                    public void onSucceed(HttpData<String> result) {
                        String key = result.getData();
                        String pwd = EncryptUtil.encryptHex(password, key);
                        modifyPassword(pwd, phone, code);
                    }

                    @Override
                    public void onFail(Exception e) {
                        toast(e.getMessage());
                        hideDialog();
                    }
                });
    }

    private void modifyPassword(String password, String mobile, String code) {
        EasyHttp.post(this)
                .api(new ResetPwdApi(pageType).setPassword(password).setMobile(mobile).setCode(code))
                .request(new HttpCallback<HttpData<Void>>(this) {
                    @Override
                    public void onSucceed(HttpData<Void> result) {
                        mOnResultListener.onSuccess();
                        finish();
                    }
                });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mOnResultListener = null;
        CallBackInstance.getInstance().setOnResultListener(null);
    }

    private ClearEditText etPhone;
    private PasswordEditText etPassword;
    private PasswordEditText etPassword1;
    private ClearEditText etCode;
    private CountdownView mCountdownView;
    private AppCompatButton btnConfirm;
}
