package com.enited.union.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.EditText;

import com.enited.union.R;
import com.enited.union.app.AppActivity;
import com.enited.union.app.CallBackInstance;
import com.enited.union.http.api.GetCodeApi;
import com.enited.union.http.api.ResetPhoneApi;
import com.enited.union.http.model.HttpData;
import com.enited.union.listener.OnResultListener;
import com.enited.union.manager.InputTextManager;
import com.enited.union.view.CountdownView;
import com.hjq.http.EasyHttp;
import com.hjq.http.listener.HttpCallback;

/**
 * author : ZhengYuanle
 * time   : 2022/9/22
 * desc   : 开通资金账户界面
 */
public final class ChangePhoneActivity extends AppActivity {

    private Button btnConfirm;
    private EditText mPhoneView;
    private EditText mCodeView;
    private CountdownView mCountdownView;
    private OnResultListener mOnResultListener = null;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_change_phone;
    }

    public static void start(Context context, OnResultListener listener) {
        CallBackInstance.getInstance().setOnResultListener(listener);
        Intent intent = new Intent(context, ChangePhoneActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    @Override
    protected void initView() {
        mOnResultListener = CallBackInstance.getInstance().getOnResultListener();

        btnConfirm = findViewById(R.id.btn_confirm);
        mPhoneView = findViewById(R.id.et_phone);
        mCodeView = findViewById(R.id.et_code);
        mCountdownView = findViewById(R.id.cv_reset_countdown);

        mTitleBar.setLeftClickListener(v -> onBackPressed());

        setOnClickListener(btnConfirm, mCountdownView);

        InputTextManager.with(getActivity())
                .addView(mPhoneView)
                .addView(mCodeView)
                .setMain(btnConfirm)
                .build();
    }

    @Override
    protected void initData() {

    }

    @Override
    public void onClick(View view) {
        if (view == btnConfirm) {
            String phone = mPhoneView.getText().toString();
            String code = mCodeView.getText().toString();

            if (phone.length() != 11) {
                mPhoneView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                toast(R.string.common_phone_input_error);
                return;
            }

            EasyHttp.post(this)
                    .api(new ResetPhoneApi().setPhone(phone).setPhoneCode(code))
                    .request(new HttpCallback<HttpData<Void>>(this) {
                        @Override
                        public void onSucceed(HttpData<Void> result) {
                            mOnResultListener.onSuccess();
                            finish();
                        }
                    });
        } else if (view == mCountdownView) {
            //获取验证码
            String phone = mPhoneView.getText().toString();
            if (phone.length() != 11) {
                mPhoneView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.shake_anim));
                toast(R.string.common_phone_input_error);
                return;
            }
            //发送短信
            EasyHttp.post(this)
                    .api(new GetCodeApi().setMobile(phone).setType(3))
                    .request(new HttpCallback<HttpData<Void>>(this) {
                        @Override
                        public void onSucceed(HttpData<Void> result) {
                            toast(R.string.common_code_send_hint);
                            mCountdownView.start();
                        }
                    });
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mOnResultListener = null;
        CallBackInstance.getInstance().setOnResultListener(null);
    }
}
