package com.enited.union.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatButton;

import com.enited.union.R;
import com.enited.union.app.AppActivity;
import com.enited.union.app.CallBackInstance;
import com.enited.union.entity.UserDetailsEntity;
import com.enited.union.http.api.OpenAccountApi;
import com.enited.union.http.api.UserDetailsApi;
import com.enited.union.http.glide.GlideApp;
import com.enited.union.http.model.HttpData;
import com.enited.union.listener.OnResultListener;
import com.enited.union.view.RatioImageView;
import com.enited.union.view.SettingBar;
import com.hjq.http.EasyHttp;
import com.hjq.http.listener.HttpCallback;

/**
 * author : ZhengYuanle
 * time   : 2022/9/22
 * desc   : 开通资金账户界面
 */
public class CapitalAccountActivity extends AppActivity {

    private UserDetailsEntity userDetailsEntity;
    private OnResultListener mOnResultListener = null;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_capital_account;
    }

    public static void start(Context context, OnResultListener listener) {
        CallBackInstance.getInstance().setOnResultListener(listener);
        Intent intent = new Intent(context, CapitalAccountActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    @Override
    protected void initView() {
        mOnResultListener = CallBackInstance.getInstance().getOnResultListener();

        ivIdCardNationalEmblem = findViewById(R.id.iv_id_card_national_emblem);
        ivIdCardPortrait = findViewById(R.id.iv_id_card_portrait);
        sbName = findViewById(R.id.sb_name);
        sbIdCard = findViewById(R.id.sb_id_card);
        sbDateOfIssue = findViewById(R.id.sb_date_of_issue);
        sbValidityOfCertificate = findViewById(R.id.sb_validity_of_certificate);
        tvIssueAuthority = findViewById(R.id.tv_issue_authority);
        tvAddress = findViewById(R.id.tv_address);
        sbPhone = findViewById(R.id.sb_phone);
        btnOpen = findViewById(R.id.btn_open);

        mTitleBar.setLeftClickListener(v -> onBackPressed());

        setOnClickListener(btnOpen);
    }

    @Override
    protected void initData() {
        getUserDetails();
    }

    @Override
    public void onClick(View view) {
        if (view == btnOpen) {
            if (userDetailsEntity == null) {
                toast("获取用户信息失败，请退出重试");
                return;
            }

            int status = userDetailsEntity.getOpenAccountState();
            if (status == 0 || status == 3) {
                openAccount(userDetailsEntity.getUid());
            }
        }
    }

    /**
     * 开户
     */
    private void openAccount(String uid) {

        EasyHttp.post(this)
                .api(new OpenAccountApi().setUid(uid))
                .request(new HttpCallback<HttpData<Void>>(this) {
                    @Override
                    public void onSucceed(HttpData<Void> result) {
                        toast("开户成功");
                        mOnResultListener.onSuccess();
                        CapitalAccountActivity.this.finish();
                    }
                });

    }


    /**
     * 获取用户信息
     */
    private void getUserDetails() {
        EasyHttp.get(this)
                .api(new UserDetailsApi())
                .request(new HttpCallback<HttpData<UserDetailsEntity>>(this) {
                    @Override
                    public void onSucceed(HttpData<UserDetailsEntity> result) {
                        userDetailsEntity = result.getData();
                        sbPhone.setRightText(userDetailsEntity.getPhone());
                        sbName.setRightText(userDetailsEntity.getRealName());
                        sbIdCard.setRightText(userDetailsEntity.getIdCard());
                        String validityPeriod = userDetailsEntity.getValidityPeriod();
                        if (!TextUtils.isEmpty(validityPeriod)) {
                            //有效期限，YYYY.MM.DD-YYYY.MM.DD 或 YYYY.MM.DD-长期  2019.01.01-2039.01.01
                            String[] times = validityPeriod.split("-");
                            if (times.length == 2) {
                                sbDateOfIssue.setRightText(times[0]);
                                sbValidityOfCertificate.setRightText(times[1]);
                            }
                        }
                        tvIssueAuthority.setText(userDetailsEntity.getIssuedBy());
                        tvAddress.setText(userDetailsEntity.getAddress());

                        if (!TextUtils.isEmpty(userDetailsEntity.getIdCardBackP())) {
                            GlideApp.with(getContext())
                                    .load(userDetailsEntity.getIdCardBackP())
                                    .error(R.mipmap.pic_id_card_error)
                                    .fitCenter()
                                    .into(ivIdCardPortrait);
                        }
                        if (!TextUtils.isEmpty(userDetailsEntity.getIdCardJustP())) {
                            GlideApp.with(getContext())
                                    .load(userDetailsEntity.getIdCardJustP())
                                    .error(R.mipmap.pic_id_card_error)
                                    .fitCenter()
                                    .into(ivIdCardNationalEmblem);
                        }
                        //开户状态 0 待开户  1开户中  2开户成功 3开户失败 4已开户待激活
                        int status = userDetailsEntity.getOpenAccountState();
                        if (status == 0 || status == 3) {
                            btnOpen.setText("下一步");
                        } else if (status == 2) {
                            btnOpen.setText("已开户");
                            btnOpen.setEnabled(false);
                        } else {
                            btnOpen.setText("立即开户");
                        }
                    }
                });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mOnResultListener = null;
        CallBackInstance.getInstance().setOnResultListener(null);
    }

    private RatioImageView ivIdCardNationalEmblem;
    private RatioImageView ivIdCardPortrait;
    private SettingBar sbName;
    private SettingBar sbIdCard;
    private SettingBar sbDateOfIssue;
    private SettingBar sbValidityOfCertificate;
    private TextView tvIssueAuthority;
    private TextView tvAddress;
    private SettingBar sbPhone;
    private AppCompatButton btnOpen;
}
