package com.enited.union.http.model;

import android.text.TextUtils;

import java.util.List;

/**
 * author : ZhengYuanle
 * time   : 2022/7/4
 * desc   : 请求数据带list
 */
public class HttpListData<T> {

    /**
     * 返回码
     */
    private int code;
    /**
     * 提示语
     */
    private String msg;
    /**
     * 提示语
     */
    private String message;
    /**
     * 收入
     */
    private Float totalTransAmt;
    /**
     * 支出
     */
    private Float totalmTransAmt;
    /**
     * 总条数
     */
    private int total;
    /**
     * 数据
     */
    private List<T> data;

    public List<T> getRows() {
        return data;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        if (TextUtils.isEmpty(msg)) {
            return message;
        }
        return msg;
    }

    /**
     * 收入
     */
    public Float getTotalTransAmt() {
        return totalTransAmt;
    }

    /**
     * 支出
     */
    public Float getTotalMTransAmt() {
        return totalmTransAmt;
    }

    public int getTotal() {
        return total;
    }

    /**
     * 是否请求成功
     */
    public boolean isRequestSucceed() {
        return code == 200;
    }

    /**
     * 是否 Token 失效
     */
    public boolean isTokenFailure() {
        return code == 100004;
    }
}
