package com.enited.union.http.model;

import android.text.TextUtils;

/**
 * author : ZhengYuanle
 * time   : 2022/6/28
 * desc   : 统一接口数据结构
 */
public class HttpData<T> {

    /**
     * 返回码
     */
    private int code;
    /**
     * 提示语
     */
    private String msg;
    /**
     * 提示语
     */
    private String message;
    /**
     * 数据
     */
    private T data;

    public int getCode() {
        return code;
    }

    public String getMessage() {
        if (TextUtils.isEmpty(msg)) {
            return message;
        }
        return msg;
    }

    public T getData() {
        return data;
    }

    /**
     * 是否请求成功
     */
    public boolean isRequestSucceed() {
        return code == 200;
    }

    /**
     * 是否 Token 失效
     */
    public boolean isTokenFailure() {
        return code == 100004;
    }
}