package com.enited.union.http.api;

import com.hjq.http.config.IRequestApi;

import java.util.ArrayList;
import java.util.List;

/**
 * author : ZhengYuanle
 * time   : 2022/7/5
 * desc   : 获取个人实名认证地址 POST
 */
public class GetIdentityUrlApi implements IRequestApi {

    @Override
    public String getApi() {
        return "basic/userAccount/api/indivIdentityUrl";
    }

    public GetIdentityUrlApi setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public GetIdentityUrlApi setContextInfo(ContextInfoEntity contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public GetIdentityUrlApi setIndivInfo(IndivInfoEntity indivInfo) {
        this.indivInfo = indivInfo;
        return this;
    }

    /**
     * E签宝个人账号ID
     */
    private String accountId;
    /**
     * 指定默认认证类型（打开认证页面所展示的第一个认证类型） PSN_FACEAUTH_BYURL 个人刷脸认证
     */
    private String authType = "PSN_FACEAUTH_BYURL";
    /**
     * 指定页面显示认证方式
     * PSN_BANK4_AUTHCODE 个人银行卡四要素认证
     * PSN_TELECOM_AUTHCODE 个人运营商三要素认证
     * PSN_FACEAUTH_BYURL 个人刷脸认证
     */
    private List<String> availableAuthTypes = new ArrayList<String>() {
        {
            add("PSN_FACEAUTH_BYURL");
        }
    };
    /**
     * 业务方交互上下文信息，有统计需求或者分账需求必填部分参数
     */
    private ContextInfoEntity contextInfo;
    /**
     * 个人实名认证的基本信息
     */
    private IndivInfoEntity indivInfo;
    /**
     * 是否允许重复实名，默认允许
     */
    private boolean repeatIdentity = true;

    public static class ContextInfoEntity {
        /**
         * 认证发起来源，BROWSER - 浏览器；APP - 移动端APP。不填默认为为BROWSER
         */
        private String origin = "APP";
        /**
         * 认证完成是否显示结果页,默认显示
         */
        private boolean showResultPage = false;
        /**
         * 发起方业务上下文标识\n * 在异步通知时发送回发起方\n * 直接对接客户建议上传相关订单Id或会员Id\n * 渠道分销商建议上传客户唯一Id
         */
        private String contextId;

        public void setContextId(String contextId) {
            this.contextId = contextId;
        }
    }

    public static class IndivInfoEntity {
        /**
         * 个人证件号
         */
        private String certNo;
        /**
         * 个人证件类型
         * INDIVIDUAL_CH_IDCARD 中国大陆身份证
         */
        private String certType = "INDIVIDUAL_CH_IDCARD";
        /**
         * 个人手机号
         */
        private String mobileNo;
        /**
         * 个人姓名
         */
        private String name;

        public void setCertNo(String certNo) {
            this.certNo = certNo;
        }

        public void setMobileNo(String mobileNo) {
            this.mobileNo = mobileNo;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
